/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.InputPortExtender;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.PortPairExtender;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.Precondition;
import com.rapidminer.operator.ports.metadata.SimplePrecondition;
import com.rapidminer.operator.ports.metadata.SubprocessTransformRule;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import java.util.List;

public class ExampleSetIterator
extends OperatorChain {
    private final InputPortExtender exampleSetExtender = new InputPortExtender("example set", this.getInputPorts()){

        @Override
        protected Precondition makePrecondition(InputPort port) {
            return new SimplePrecondition(port, new ExampleSetMetaData(), false);
        }
    };
    private final PortPairExtender outputExtender = new PortPairExtender("output", this.getSubprocess(0).getInnerSinks(), this.getOutputPorts());
    private final OutputPort exampleSetInnerSource = (OutputPort)this.getSubprocess(0).getInnerSources().createPort("example set");
    private final InputPort performanceInnerSink = (InputPort)this.getSubprocess(0).getInnerSinks().createPort("performance");
    public static final String PARAMETER_ONLY_BEST = "only_best";

    public ExampleSetIterator(OperatorDescription description) {
        super(description, "Subprocess");
        this.exampleSetExtender.start();
        this.outputExtender.start();
        this.performanceInnerSink.addPrecondition(new SimplePrecondition(this.performanceInnerSink, new MetaData(PerformanceVector.class), false){

            @Override
            public boolean isMandatory() {
                return ExampleSetIterator.this.getParameterAsBoolean(ExampleSetIterator.PARAMETER_ONLY_BEST);
            }
        });
        this.getTransformer().addRule(this.exampleSetExtender.makeFlatteningPassThroughRule(this.exampleSetInnerSource));
        this.getTransformer().addRule(new SubprocessTransformRule(this.getSubprocess(0)));
        this.getTransformer().addRule(this.outputExtender.makePassThroughRule());
    }

    @Override
    public void doWork() throws OperatorException {
        List eSetList = this.exampleSetExtender.getData(true);
        boolean onlyBest = this.getParameterAsBoolean(PARAMETER_ONLY_BEST);
        double bestFitness = Double.NEGATIVE_INFINITY;
        for (ExampleSet exampleSet : eSetList) {
            PerformanceVector pv;
            double fitness;
            this.exampleSetInnerSource.deliver(exampleSet);
            this.getSubprocess(0).execute();
            if (onlyBest && (fitness = (pv = (PerformanceVector)this.performanceInnerSink.getData()).getMainCriterion().getFitness()) > bestFitness) {
                bestFitness = fitness;
                this.outputExtender.passDataThrough();
            }
            this.inApplyLoop();
        }
        if (!onlyBest) {
            this.outputExtender.passDataThrough();
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeBoolean type = new ParameterTypeBoolean(PARAMETER_ONLY_BEST, "Return only best result? (Requires a the performance port to be connected.)", false);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

