/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.ports.CollectingPortPairExtender;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.PassThroughRule;
import com.rapidminer.operator.ports.metadata.SubprocessTransformRule;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.List;

public class ExampleIterator
extends OperatorChain {
    public static final String PARAMETER_ITERATION_MACRO = "iteration_macro";
    public static final String DEFAULT_ITERATION_MACRO_NAME = "example";
    private final InputPort exampleSetInput = this.getInputPorts().createPort("example set", ExampleSet.class);
    private final OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");
    private final OutputPort exampleSetInnerSource = (OutputPort)this.getSubprocess(0).getInnerSources().createPort("example set");
    private final InputPort exampleSetInnerSink = (InputPort)this.getSubprocess(0).getInnerSinks().createPort("example set");
    private final CollectingPortPairExtender outExtender = new CollectingPortPairExtender("output", this.getSubprocess(0).getInnerSinks(), this.getOutputPorts());
    private int iteration;

    public ExampleIterator(OperatorDescription description) {
        super(description, "Example Process");
        this.outExtender.start();
        this.getTransformer().addPassThroughRule(this.exampleSetInput, this.exampleSetInnerSource);
        this.getTransformer().addRule(new SubprocessTransformRule(this.getSubprocess(0)));
        this.getTransformer().addRule(new PassThroughRule(this.exampleSetInput, this.exampleSetOutput, false){

            @Override
            public MetaData modifyMetaData(MetaData unmodifiedMetaData) {
                if (ExampleIterator.this.exampleSetInnerSink.isConnected()) {
                    return ExampleIterator.this.exampleSetInnerSink.getMetaData();
                }
                return new ExampleSetMetaData();
            }
        });
        this.getTransformer().addRule(this.outExtender.makePassThroughRule());
        this.addValue(new ValueDouble("iteration", "The number of the current iteration / loop / example."){

            @Override
            public double getDoubleValue() {
                return ExampleIterator.this.iteration;
            }
        });
    }

    @Override
    public void doWork() throws OperatorException {
        this.outExtender.reset();
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        String iterationMacroName = this.getParameterAsString(PARAMETER_ITERATION_MACRO);
        boolean innerSinkIsConnected = this.exampleSetInnerSink.isConnected();
        this.iteration = 1;
        while (this.iteration <= exampleSet.size()) {
            this.getProcess().getMacroHandler().addMacro(iterationMacroName, String.valueOf(this.iteration));
            this.exampleSetInnerSource.deliver(innerSinkIsConnected ? exampleSet : (ExampleSet)exampleSet.clone());
            this.getSubprocess(0).execute();
            this.inApplyLoop();
            if (innerSinkIsConnected) {
                exampleSet = (ExampleSet)this.exampleSetInnerSink.getData();
            }
            this.outExtender.collect();
            ++this.iteration;
        }
        this.getProcess().getMacroHandler().removeMacro(iterationMacroName);
        this.exampleSetOutput.deliver(exampleSet);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_ITERATION_MACRO, "The name of the macro which holds the index of the current example in each iteration.", DEFAULT_ITERATION_MACRO_NAME, false));
        return types;
    }
}

