/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.meta.ESParameterOptimization;
import com.rapidminer.operator.meta.ParameterOptimizationOperator;
import com.rapidminer.operator.meta.ParameterSet;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.value.ParameterValueRange;
import com.rapidminer.parameter.value.ParameterValues;
import com.rapidminer.tools.RandomGenerator;
import com.rapidminer.tools.math.optimization.ec.es.ESOptimization;
import com.rapidminer.tools.math.optimization.ec.es.Individual;
import com.rapidminer.tools.math.optimization.ec.es.OptimizationValueType;
import java.util.Iterator;
import java.util.List;

public class EvolutionaryParameterOptimizationOperator
extends ParameterOptimizationOperator {
    public static final String PARAMETER_MAX_GENERATIONS = "max_generations";
    public static final String PARAMETER_GENERATIONS_WITHOUT_IMPROVAL = "generations_without_improval";
    public static final String PARAMETER_POPULATION_SIZE = "population_size";
    public static final String PARAMETER_TOURNAMENT_FRACTION = "tournament_fraction";
    public static final String PARAMETER_KEEP_BEST = "keep_best";
    public static final String PARAMETER_MUTATION_TYPE = "mutation_type";
    public static final String PARAMETER_SELECTION_TYPE = "selection_type";
    public static final String PARAMETER_CROSSOVER_PROB = "crossover_prob";
    public static final String PARAMETER_SHOW_CONVERGENCE_PLOT = "show_convergence_plot";
    public static final String PARAMETER_SPECIFIY_POPULATION_SIZE = "specify_population_size";
    private ESOptimization optimizer;
    private double bestFitnessEver = Double.NaN;
    private double lastGenerationsPerformance = Double.NaN;
    private Operator[] operators;
    private String[] parameters;
    private OptimizationValueType[] types;

    public EvolutionaryParameterOptimizationOperator(OperatorDescription description) {
        super(description);
        this.addValue(new ValueDouble("best", "best performance ever"){

            @Override
            public double getDoubleValue() {
                return EvolutionaryParameterOptimizationOperator.this.bestFitnessEver;
            }
        });
    }

    public Operator[] getOptimizationOperators() {
        return this.operators;
    }

    public String[] getOptimizationParameters() {
        return this.parameters;
    }

    public OptimizationValueType[] getOptimizationValueTypes() {
        return this.types;
    }

    @Override
    public int getParameterValueMode() {
        return 1;
    }

    @Override
    public double getCurrentBestPerformance() {
        if (this.optimizer != null) {
            return this.optimizer.getBestFitnessInGeneration();
        }
        return this.lastGenerationsPerformance;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void doWork() throws OperatorException {
        int i;
        void var6_8;
        List<ParameterValues> parameterValuesList = this.parseParameterValues(this.getParameterList("parameters"));
        if (parameterValuesList == null) {
            throw new UserError((Operator)this, 922);
        }
        Iterator<ParameterValues> iterator = parameterValuesList.iterator();
        while (iterator.hasNext()) {
            ParameterValues parameterValues = iterator.next();
            if (parameterValues instanceof ParameterValueRange) continue;
            this.getLogger().warning("Found (and deleted) unsupported parameter value definition. Parameters have to be given as range (e.g. as [2;5.7]).");
            iterator.remove();
        }
        if (parameterValuesList.size() == 0) {
            throw new UserError((Operator)this, 922);
        }
        this.operators = new Operator[parameterValuesList.size()];
        this.parameters = new String[parameterValuesList.size()];
        double[] min = new double[parameterValuesList.size()];
        double[] max = new double[parameterValuesList.size()];
        this.types = new OptimizationValueType[parameterValuesList.size()];
        int index = 0;
        for (ParameterValueRange parameterValueRange : parameterValuesList) {
            this.operators[index] = parameterValueRange.getOperator();
            this.parameters[index] = parameterValueRange.getParameterType().getKey();
            min[index] = Double.valueOf(parameterValueRange.getMin());
            max[index] = Double.valueOf(parameterValueRange.getMax());
            ParameterType targetType = parameterValueRange.getParameterType();
            if (targetType == null) {
                throw new UserError((Operator)this, 906, parameterValueRange.getOperator() + "." + parameterValueRange.getKey());
            }
            if (targetType instanceof ParameterTypeDouble) {
                this.types[index] = OptimizationValueType.VALUE_TYPE_DOUBLE;
                this.getLogger().fine("Parameter type of parameter " + targetType.getKey() + ": double");
            } else if (targetType instanceof ParameterTypeInt) {
                this.types[index] = OptimizationValueType.VALUE_TYPE_INT;
                this.getLogger().fine("Parameter type of parameter " + targetType.getKey() + ": int");
            } else {
                throw new UserError((Operator)this, 909, targetType.getKey());
            }
            ++index;
        }
        RandomGenerator random = RandomGenerator.getRandomGenerator(this);
        this.optimizer = this.createOptimizer(random);
        boolean bl = false;
        while (var6_8 < min.length) {
            this.optimizer.setMin((int)var6_8, min[var6_8]);
            this.optimizer.setMax((int)var6_8, max[var6_8]);
            this.optimizer.setValueType((int)var6_8, this.types[var6_8]);
            ++var6_8;
        }
        this.optimizer.optimize();
        double[] dArray = this.optimizer.getBestValuesEver();
        String[] bestValues = null;
        if (dArray != null) {
            bestValues = new String[dArray.length];
            for (i = 0; i < dArray.length; ++i) {
                bestValues[i] = this.types[i].equals((Object)OptimizationValueType.VALUE_TYPE_DOUBLE) ? dArray[i] + "" : (int)Math.round(dArray[i]) + "";
            }
        } else {
            bestValues = new String[this.operators.length];
            for (i = 0; i < bestValues.length; ++i) {
                bestValues[i] = "unknown";
            }
        }
        ParameterSet bestSet = new ParameterSet(this.operators, this.parameters, bestValues, this.optimizer.getBestPerformanceEver());
        this.bestFitnessEver = this.optimizer.getBestFitnessEver();
        this.lastGenerationsPerformance = this.optimizer.getBestFitnessInGeneration();
        this.optimizer = null;
        this.deliver(bestSet);
    }

    protected ESOptimization createOptimizer(RandomGenerator random) throws UndefinedParameterError {
        return new ESParameterOptimization(this, this.operators.length, 0, this.getParameterAsInt(PARAMETER_MAX_GENERATIONS), this.getParameterAsInt(PARAMETER_GENERATIONS_WITHOUT_IMPROVAL), this.getParameterAsInt(PARAMETER_POPULATION_SIZE), this.getParameterAsInt(PARAMETER_SELECTION_TYPE), this.getParameterAsDouble(PARAMETER_TOURNAMENT_FRACTION), this.getParameterAsBoolean(PARAMETER_KEEP_BEST), this.getParameterAsInt(PARAMETER_MUTATION_TYPE), this.getParameterAsDouble(PARAMETER_CROSSOVER_PROB), this.getParameterAsBoolean(PARAMETER_SHOW_CONVERGENCE_PLOT), random, this);
    }

    public ESOptimization getOptimization() {
        return this.optimizer;
    }

    public PerformanceVector setParametersAndEvaluate(Individual individual) throws OperatorException {
        double[] currentValues = individual.getValues();
        for (int j = 0; j < currentValues.length; ++j) {
            String value = this.types[j].equals((Object)OptimizationValueType.VALUE_TYPE_DOUBLE) ? currentValues[j] + "" : (int)Math.round(currentValues[j]) + "";
            this.operators[j].getParameters().setParameter(this.parameters[j], value);
            this.getLogger().fine(this.operators[j] + "." + this.parameters[j] + " = " + value);
        }
        return this.getPerformance(true);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.addAll(ESOptimization.getParameterTypes(this));
        return types;
    }

    public int getNumberOfOptimizationParameters() {
        return this.parameters.length;
    }
}

