/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.SplittedExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.PortPairExtender;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetPassThroughRule;
import com.rapidminer.operator.ports.metadata.ExampleSetPrecondition;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.ports.metadata.SubprocessTransformRule;
import com.rapidminer.parameter.UndefinedParameterError;

public class ClusterIterator
extends OperatorChain {
    private InputPort exampleSetInput = (InputPort)this.getInputPorts().createPort("example set");
    private OutputPort subsetInnerSource = (OutputPort)this.getSubprocess(0).getInnerSources().createPort("cluster subset");
    private PortPairExtender inputExtender = new PortPairExtender("in", this.getInputPorts(), this.getSubprocess(0).getInnerSources());
    private PortPairExtender outputExtender = new PortPairExtender("out", this.getSubprocess(0).getInnerSinks(), this.getOutputPorts());
    private int numberOfClusters = 0;

    public ClusterIterator(OperatorDescription description) {
        super(description, "Cluster Iteration");
        this.inputExtender.start();
        this.outputExtender.start();
        this.exampleSetInput.addPrecondition(new ExampleSetPrecondition(this.exampleSetInput, 0, "cluster"));
        this.getTransformer().addRule(new ExampleSetPassThroughRule(this.exampleSetInput, this.subsetInnerSource, SetRelation.EQUAL){

            @Override
            public ExampleSetMetaData modifyExampleSet(ExampleSetMetaData metaData) throws UndefinedParameterError {
                metaData.getNumberOfExamples().reduceByUnknownAmount();
                return super.modifyExampleSet(metaData);
            }
        });
        this.getTransformer().addRule(this.inputExtender.makePassThroughRule());
        this.getTransformer().addRule(new SubprocessTransformRule(this.getSubprocess(0)));
        this.getTransformer().addRule(this.outputExtender.makePassThroughRule());
    }

    @Override
    public void doWork() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        Attribute clusterAttribute = exampleSet.getAttributes().getCluster();
        if (clusterAttribute == null) {
            throw new UserError((Operator)this, 113, "cluster");
        }
        SplittedExampleSet splitted = SplittedExampleSet.splitByAttribute(exampleSet, clusterAttribute);
        this.numberOfClusters = splitted.getNumberOfSubsets();
        for (int i = 0; i < this.numberOfClusters; ++i) {
            splitted.selectSingleSubset(i);
            this.subsetInnerSource.deliver(splitted);
            this.inputExtender.passCloneThrough();
            super.doWork();
            this.inApplyLoop();
        }
        this.outputExtender.passDataThrough();
    }
}

