/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetPassThroughRule;
import com.rapidminer.operator.ports.metadata.PassThroughRule;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.ports.metadata.SubprocessTransformRule;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.List;

public class BatchProcessing
extends OperatorChain {
    public static final String PARAMETER_BATCH_SIZE = "batch_size";
    private final InputPort exampleSetInput = this.getInputPorts().createPort("example set", new ExampleSetMetaData());
    private final OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");
    private final OutputPort exampleSetInnerSource = (OutputPort)this.getSubprocess(0).getInnerSources().createPort("exampleSet");

    public BatchProcessing(OperatorDescription description) {
        super(description, "Batch Process");
        this.getTransformer().addRule(new ExampleSetPassThroughRule(this.exampleSetInput, this.exampleSetInnerSource, SetRelation.EQUAL){

            @Override
            public ExampleSetMetaData modifyExampleSet(ExampleSetMetaData metaData) throws UndefinedParameterError {
                metaData.setNumberOfExamples(BatchProcessing.this.getParameterAsInt(BatchProcessing.PARAMETER_BATCH_SIZE));
                return super.modifyExampleSet(metaData);
            }
        });
        this.getTransformer().addRule(new SubprocessTransformRule(this.getSubprocess(0)));
        this.getTransformer().addRule(new PassThroughRule(this.exampleSetInput, this.exampleSetOutput, false));
    }

    @Override
    public void doWork() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        int batchSize = this.getParameterAsInt(PARAMETER_BATCH_SIZE);
        int size = exampleSet.size();
        for (int currentStart = 0; currentStart < size; currentStart += batchSize) {
            ExampleSet materializedSet = Tools.getLinearSubsetCopy(exampleSet, batchSize, currentStart);
            this.exampleSetInnerSource.deliver(materializedSet);
            this.getSubprocess(0).execute();
            this.inApplyLoop();
        }
        this.exampleSetOutput.deliver(exampleSet);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeInt(PARAMETER_BATCH_SIZE, "This number of examples is processed batch-wise by the inner operators of this operator.", 1, Integer.MAX_VALUE, 1000, false));
        return types;
    }
}

