/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.InputPortExtender;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.Ports;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.tools.math.AverageVector;
import com.rapidminer.tools.math.RunVector;
import java.util.List;

public class AverageBuilder
extends Operator {
    InputPortExtender inExtender = new InputPortExtender("averagable", (Ports<InputPort>)this.getInputPorts(), new MetaData(AverageVector.class), 2);
    private final OutputPort runOutput = (OutputPort)this.getOutputPorts().createPort("average");

    public AverageBuilder(OperatorDescription description) {
        super(description);
        this.inExtender.start();
        this.getTransformer().addRule(this.inExtender.makeFlatteningPassThroughRule(this.runOutput));
    }

    @Override
    public void doWork() throws OperatorException {
        RunVector runVector = new RunVector();
        List averageVectors = this.inExtender.getData(true);
        Class<?> clazz = null;
        for (AverageVector av : averageVectors) {
            if (clazz == null) {
                clazz = av.getClass();
            } else if (!av.getClass().equals(clazz)) {
                this.getLogger().warning("Received inputs of different types (" + clazz.getName() + " and " + av.getName() + "). Ignoring the latter.");
                continue;
            }
            runVector.addVector(av);
        }
        this.runOutput.deliver(runVector.average());
    }
}

