/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.SplittedExampleSet;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.PortPairExtender;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetPassThroughRule;
import com.rapidminer.operator.ports.metadata.MDInteger;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.ports.metadata.SimplePrecondition;
import com.rapidminer.operator.ports.metadata.SubprocessTransformRule;
import com.rapidminer.parameter.UndefinedParameterError;

public abstract class AbstractSplitChain
extends OperatorChain {
    private final InputPort exampleSetInput = (InputPort)this.getInputPorts().createPort("example set");
    private final OutputPort firstNestedExampleSetOutput = (OutputPort)this.getSubprocess(0).getInnerSources().createPort("example set");
    private final PortPairExtender firstToSecondExtender = new PortPairExtender("through", this.getSubprocess(0).getInnerSinks(), this.getSubprocess(1).getInnerSources());
    private final OutputPort secondNestedExampleSetOutput = (OutputPort)this.getSubprocess(1).getInnerSources().createPort("example set");
    private final PortPairExtender secondToOutputExtender = new PortPairExtender("through", this.getSubprocess(1).getInnerSinks(), this.getOutputPorts());

    public AbstractSplitChain(OperatorDescription description) {
        super(description, "First Part", "Second Part");
        this.firstToSecondExtender.start();
        this.secondToOutputExtender.start();
        this.exampleSetInput.addPrecondition(new SimplePrecondition(this.exampleSetInput, new ExampleSetMetaData()));
        this.getTransformer().addRule(new ExampleSetPassThroughRule(this.exampleSetInput, this.firstNestedExampleSetOutput, SetRelation.EQUAL){

            @Override
            public ExampleSetMetaData modifyExampleSet(ExampleSetMetaData metaData) throws UndefinedParameterError {
                metaData.setNumberOfExamples(AbstractSplitChain.this.getNumberOfExamplesFirst(metaData.getNumberOfExamples()));
                return super.modifyExampleSet(metaData);
            }
        });
        this.getTransformer().addRule(new ExampleSetPassThroughRule(this.exampleSetInput, this.secondNestedExampleSetOutput, SetRelation.EQUAL){

            @Override
            public ExampleSetMetaData modifyExampleSet(ExampleSetMetaData metaData) throws UndefinedParameterError {
                metaData.setNumberOfExamples(AbstractSplitChain.this.getNumberOfExamplesSecond(metaData.getNumberOfExamples()));
                return super.modifyExampleSet(metaData);
            }
        });
        this.getTransformer().addRule(new SubprocessTransformRule(this.getSubprocess(0)));
        this.getTransformer().addRule(this.firstToSecondExtender.makePassThroughRule());
        this.getTransformer().addRule(new SubprocessTransformRule(this.getSubprocess(1)));
        this.getTransformer().addRule(this.secondToOutputExtender.makePassThroughRule());
    }

    protected abstract MDInteger getNumberOfExamplesFirst(MDInteger var1) throws UndefinedParameterError;

    protected abstract MDInteger getNumberOfExamplesSecond(MDInteger var1) throws UndefinedParameterError;

    protected abstract SplittedExampleSet createSplittedExampleSet(ExampleSet var1) throws OperatorException;

    @Override
    public void doWork() throws OperatorException {
        ExampleSet inputSet = (ExampleSet)this.exampleSetInput.getData();
        SplittedExampleSet exampleSet = this.createSplittedExampleSet(inputSet);
        exampleSet.selectSingleSubset(0);
        this.firstNestedExampleSetOutput.deliver(exampleSet);
        this.getSubprocess(0).execute();
        exampleSet.selectSingleSubset(1);
        this.secondNestedExampleSetOutput.deliver(exampleSet);
        this.firstToSecondExtender.passDataThrough();
        this.getSubprocess(1).execute();
        this.secondToOutputExtender.passDataThrough();
    }

    protected InputPort getExampleSetInputPort() {
        return this.exampleSetInput;
    }
}

