/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.ports.CollectingPortPairExtender;
import com.rapidminer.operator.ports.PortPairExtender;
import com.rapidminer.operator.ports.metadata.SubprocessTransformRule;

public abstract class AbstractIteratingOperatorChain
extends OperatorChain {
    private final PortPairExtender inputPortPairExtender = new PortPairExtender("input", this.getInputPorts(), this.getSubprocess(0).getInnerSources());
    private final CollectingPortPairExtender outExtender = new CollectingPortPairExtender("output", this.getSubprocess(0).getInnerSinks(), this.getOutputPorts());
    private int currentIteration = 0;

    public AbstractIteratingOperatorChain(OperatorDescription description) {
        super(description, "Iteration");
        this.inputPortPairExtender.start();
        this.outExtender.start();
        this.getTransformer().addRule(this.inputPortPairExtender.makePassThroughRule());
        this.getTransformer().addRule(new SubprocessTransformRule(this.getSubprocess(0)));
        this.getTransformer().addRule(this.outExtender.makePassThroughRule());
        this.addValue(new ValueDouble("iteration", "The iteration currently performed by this looping operator."){

            @Override
            public double getDoubleValue() {
                return AbstractIteratingOperatorChain.this.currentIteration;
            }
        });
    }

    @Override
    public void doWork() throws OperatorException {
        this.outExtender.reset();
        this.currentIteration = 0;
        while (!this.shouldStop(this.getSubprocess(0).getInnerSinks().createIOContainer(false))) {
            this.getLogger().fine("Starting iteration " + (this.currentIteration + 1));
            this.inputPortPairExtender.passDataThrough();
            this.getSubprocess(0).execute();
            this.outExtender.collect();
            this.inApplyLoop();
            this.getLogger().fine("Completed iteration " + (this.currentIteration + 1));
            ++this.currentIteration;
        }
    }

    protected int getIteration() {
        return this.currentIteration;
    }

    abstract boolean shouldStop(IOContainer var1) throws OperatorException;
}

