/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.SplittedExampleSet;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.meta.AbstractSplitChain;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.metadata.MDInteger;
import com.rapidminer.operator.ports.metadata.MetaDataInfo;
import com.rapidminer.operator.ports.metadata.SimpleMetaDataError;
import com.rapidminer.operator.ports.quickfix.ParameterSettingQuickFix;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.tools.RandomGenerator;
import java.util.Collections;
import java.util.List;

public class AbsoluteSplitChain
extends AbstractSplitChain {
    public static final String PARAMETER_SAMPLING_TYPE = "sampling_type";
    private static final String PARAMETER_NUMBER_TRAINING_EXAMPLES = "first_set_size";
    private static final String PARAMETER_NUMBER_TEST_EXAMPLES = "second_set_size";
    private static final String PARAMETER_RESTRICT_FIRST = "restrict_first";

    public AbsoluteSplitChain(OperatorDescription description) {
        super(description);
    }

    @Override
    protected MDInteger getNumberOfExamplesFirst(MDInteger numberOfExamples) throws UndefinedParameterError {
        int desiredSize = this.getParameterAsBoolean(PARAMETER_RESTRICT_FIRST) ? this.getParameterAsInt(PARAMETER_NUMBER_TRAINING_EXAMPLES) : this.getParameterAsInt(PARAMETER_NUMBER_TEST_EXAMPLES);
        if (numberOfExamples.isAtLeast(desiredSize) == MetaDataInfo.NO) {
            if (this.getParameterAsBoolean(PARAMETER_RESTRICT_FIRST)) {
                this.getExampleSetInputPort().addError(new SimpleMetaDataError(ProcessSetupError.Severity.ERROR, (Port)this.getExampleSetInputPort(), Collections.singletonList(new ParameterSettingQuickFix(this, PARAMETER_NUMBER_TRAINING_EXAMPLES, ((Integer)numberOfExamples.getNumber()).toString())), "exampleset.need_more_examples", desiredSize + ""));
            } else {
                this.getExampleSetInputPort().addError(new SimpleMetaDataError(ProcessSetupError.Severity.ERROR, (Port)this.getExampleSetInputPort(), Collections.singletonList(new ParameterSettingQuickFix(this, PARAMETER_NUMBER_TEST_EXAMPLES, ((Integer)numberOfExamples.getNumber()).toString())), "exampleset.need_more_examples", desiredSize + ""));
            }
        }
        if (this.getParameterAsBoolean(PARAMETER_RESTRICT_FIRST)) {
            return new MDInteger(desiredSize);
        }
        return numberOfExamples.subtract(desiredSize);
    }

    @Override
    protected MDInteger getNumberOfExamplesSecond(MDInteger numberOfExamples) throws UndefinedParameterError {
        if (this.getParameterAsBoolean(PARAMETER_RESTRICT_FIRST)) {
            return numberOfExamples.subtract(this.getParameterAsInt(PARAMETER_NUMBER_TRAINING_EXAMPLES));
        }
        return new MDInteger(this.getParameterAsInt(PARAMETER_NUMBER_TEST_EXAMPLES));
    }

    @Override
    protected SplittedExampleSet createSplittedExampleSet(ExampleSet inputSet) throws OperatorException {
        int size = -1;
        size = this.getParameterAsBoolean(PARAMETER_RESTRICT_FIRST) ? this.getParameterAsInt(PARAMETER_NUMBER_TRAINING_EXAMPLES) : inputSet.size() - this.getParameterAsInt(PARAMETER_NUMBER_TEST_EXAMPLES);
        return new SplittedExampleSet(inputSet, (double)size / (double)inputSet.size(), this.getParameterAsInt(PARAMETER_SAMPLING_TYPE), this.getParameterAsBoolean("use_local_random_seed"), this.getParameterAsInt("local_random_seed"));
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean(PARAMETER_RESTRICT_FIRST, "If checked, the size if the first set is fixed. Otherwise the size of the second part might be specified. However, the not fixed part will reciev all remaining examples.", true, false));
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_NUMBER_TRAINING_EXAMPLES, "Absolute size of the training set. -1 equal to not defined", 1, Integer.MAX_VALUE, 1);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_RESTRICT_FIRST, true, true));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_NUMBER_TEST_EXAMPLES, "Absolute size of the test set. -1 equal to not defined", 1, Integer.MAX_VALUE, 1);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_RESTRICT_FIRST, true, false));
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeCategory(PARAMETER_SAMPLING_TYPE, "Defines the sampling type of this operator.", SplittedExampleSet.SAMPLING_NAMES, 1));
        types.addAll(RandomGenerator.getRandomGeneratorParameters(this));
        return types;
    }
}

