/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.macros;

import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.DummyPortPairExtender;
import com.rapidminer.operator.ports.PortPairExtender;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeEnumeration;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.List;

public class UnsetMacroOperator
extends Operator {
    public static final String PARAMETER_MACRO = "macro";
    public static final String PARAMETER_MACRO_ENUM = "macros";
    private PortPairExtender dummyPorts = new DummyPortPairExtender("through", this.getInputPorts(), this.getOutputPorts());

    public UnsetMacroOperator(OperatorDescription description) {
        super(description);
        this.dummyPorts.start();
        this.getTransformer().addRule(this.dummyPorts.makePassThroughRule());
    }

    @Override
    public void doWork() throws OperatorException {
        if (this.isParameterSet(PARAMETER_MACRO)) {
            String macroName = this.getParameterAsString(PARAMETER_MACRO);
            this.getProcess().getMacroHandler().removeMacro(macroName);
        }
        if (this.isParameterSet(PARAMETER_MACRO_ENUM)) {
            String[] macroNames;
            for (String macroName : macroNames = ParameterTypeEnumeration.transformString2Enumeration(this.getParameterAsString(PARAMETER_MACRO_ENUM))) {
                this.getProcess().getMacroHandler().removeMacro(macroName);
            }
        }
        this.dummyPorts.passDataThrough();
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_MACRO, "A single macro which should be unset and removed.", true, false));
        types.add(new ParameterTypeEnumeration(PARAMETER_MACRO_ENUM, "A list of parameter types to unset and remove. Does the same as the macro parameter, but allows to remove macros on batch.", (ParameterType)new ParameterTypeString(PARAMETER_MACRO, "The name of a macro which should be unset and removed"), false));
        return types;
    }
}

