/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.tree.criterions;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.tree.AbstractTreeLearner;
import com.rapidminer.operator.learner.tree.FrequencyCalculator;
import com.rapidminer.operator.learner.tree.MinimalGainHandler;
import com.rapidminer.operator.learner.tree.criterions.Criterion;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.tools.Tools;

public abstract class AbstractCriterion
implements Criterion {
    protected double leftWeight;
    protected double rightWeight;
    protected double totalWeight;
    protected double[] totalLabelWeights;
    protected double[] leftLabelWeights;
    protected double[] rightLabelWeights;
    protected Attribute labelAttribute;
    protected Attribute weightAttribute;

    @Override
    public boolean supportsIncrementalCalculation() {
        return false;
    }

    @Override
    public void startIncrementalCalculation(ExampleSet exampleSet) {
        FrequencyCalculator calculator = new FrequencyCalculator();
        this.rightLabelWeights = calculator.getLabelWeights(exampleSet);
        this.leftLabelWeights = new double[this.rightLabelWeights.length];
        this.totalLabelWeights = new double[this.rightLabelWeights.length];
        System.arraycopy(this.rightLabelWeights, 0, this.totalLabelWeights, 0, this.rightLabelWeights.length);
        this.leftWeight = 0.0;
        this.totalWeight = this.rightWeight = calculator.getTotalWeight(this.totalLabelWeights);
        this.labelAttribute = exampleSet.getAttributes().getLabel();
        this.weightAttribute = exampleSet.getAttributes().getWeight();
    }

    @Override
    public void swapExample(Example example) {
        double weight = 1.0;
        if (this.weightAttribute != null) {
            weight = example.getValue(this.weightAttribute);
        }
        int label = (int)example.getValue(this.labelAttribute);
        this.leftWeight += weight;
        this.rightWeight -= weight;
        int n = label;
        this.leftLabelWeights[n] = this.leftLabelWeights[n] + weight;
        int n2 = label;
        this.rightLabelWeights[n2] = this.rightLabelWeights[n2] - weight;
    }

    @Override
    public double getIncrementalBenefit() {
        return 0.0;
    }

    public static Criterion createCriterion(ParameterHandler handler, double minimalGain) throws OperatorException {
        String criterionName = handler.getParameterAsString("criterion");
        Class criterionClass = null;
        for (int i = 0; i < AbstractTreeLearner.CRITERIA_NAMES.length; ++i) {
            if (!AbstractTreeLearner.CRITERIA_NAMES[i].equals(criterionName)) continue;
            criterionClass = AbstractTreeLearner.CRITERIA_CLASSES[i];
        }
        if (criterionClass == null && criterionName != null) {
            try {
                criterionClass = Tools.classForName(criterionName);
            }
            catch (ClassNotFoundException e) {
                throw new OperatorException("Cannot find criterion '" + criterionName + "' and cannot instantiate a class with this name.");
            }
        }
        if (criterionClass != null) {
            try {
                Criterion criterion = (Criterion)criterionClass.newInstance();
                if (criterion instanceof MinimalGainHandler) {
                    ((MinimalGainHandler)((Object)criterion)).setMinimalGain(minimalGain);
                }
                return criterion;
            }
            catch (InstantiationException e) {
                throw new OperatorException("Cannot instantiate criterion class '" + criterionClass.getName() + "'.");
            }
            catch (IllegalAccessException e) {
                throw new OperatorException("Cannot access criterion class '" + criterionClass.getName() + "'.");
            }
        }
        throw new OperatorException("No relevance criterion defined.");
    }
}

