/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.tree;

import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.SimplePredictionModel;
import com.rapidminer.operator.learner.tree.Edge;
import com.rapidminer.operator.learner.tree.SplitCondition;
import com.rapidminer.operator.learner.tree.Tree;
import java.util.Iterator;

public class TreeModel
extends SimplePredictionModel {
    private static final long serialVersionUID = 4368631725370998591L;
    private Tree root;

    public TreeModel(ExampleSet exampleSet, Tree root) {
        super(exampleSet);
        this.root = root;
    }

    public Tree getRoot() {
        return this.root;
    }

    @Override
    public double predict(Example example) throws OperatorException {
        return this.predict(example, this.root);
    }

    private double predict(Example example, Tree node) {
        if (node.isLeaf()) {
            Iterator<String> s = node.getCounterMap().keySet().iterator();
            int[] counts = new int[this.getLabel().getMapping().size()];
            int sum = 0;
            while (s.hasNext()) {
                String className = s.next();
                int count = node.getCount(className);
                int index = this.getLabel().getMapping().getIndex(className);
                counts[index] = count;
                sum += count;
            }
            for (int i = 0; i < counts.length; ++i) {
                example.setConfidence(this.getLabel().getMapping().mapIndex(i), (double)counts[i] / (double)sum);
            }
            return this.getLabel().getMapping().getIndex(node.getLabel());
        }
        Iterator<Edge> childIterator = node.childIterator();
        while (childIterator.hasNext()) {
            Edge edge = childIterator.next();
            SplitCondition condition = edge.getCondition();
            if (!condition.test(example)) continue;
            return this.predict(example, edge.getChild());
        }
        String majorityClass = null;
        int majorityCounter = -1;
        Iterator<String> s = node.getCounterMap().keySet().iterator();
        int[] counts = new int[this.getLabel().getMapping().size()];
        int sum = 0;
        while (s.hasNext()) {
            String className = s.next();
            int count = node.getCount(className);
            int index = this.getLabel().getMapping().getIndex(className);
            counts[index] = count;
            sum += count;
            if (count <= majorityCounter) continue;
            majorityCounter = count;
            majorityClass = className;
        }
        for (int i = 0; i < counts.length; ++i) {
            example.setConfidence(this.getLabel().getMapping().mapIndex(i), (double)counts[i] / (double)sum);
        }
        if (majorityClass != null) {
            return this.getLabel().getMapping().getIndex(majorityClass);
        }
        return 0.0;
    }

    @Override
    public String toString() {
        return this.root.toString();
    }
}

