/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.tree;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.SplittedExampleSet;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.tree.AbstractSplitCondition;
import com.rapidminer.operator.learner.tree.Benefit;
import com.rapidminer.operator.learner.tree.DecisionTreeLeafCreator;
import com.rapidminer.operator.learner.tree.GreaterSplitCondition;
import com.rapidminer.operator.learner.tree.LeafCreator;
import com.rapidminer.operator.learner.tree.LessEqualsSplitCondition;
import com.rapidminer.operator.learner.tree.MinSizeTermination;
import com.rapidminer.operator.learner.tree.NominalSplitCondition;
import com.rapidminer.operator.learner.tree.NumericalSplitter;
import com.rapidminer.operator.learner.tree.Pruner;
import com.rapidminer.operator.learner.tree.SplitPreprocessing;
import com.rapidminer.operator.learner.tree.Terminator;
import com.rapidminer.operator.learner.tree.Tree;
import com.rapidminer.operator.learner.tree.criterions.Criterion;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public class TreeBuilder {
    protected Terminator minLeafSizeTerminator;
    private List<Terminator> otherTerminators;
    private int minSizeForSplit = 2;
    private Criterion criterion;
    private NumericalSplitter splitter;
    protected SplitPreprocessing preprocessing = null;
    private Pruner pruner;
    protected LeafCreator leafCreator = new DecisionTreeLeafCreator();
    protected int numberOfPrepruningAlternatives = 0;
    protected boolean usePrePruning = true;

    public TreeBuilder(Criterion criterion, List<Terminator> terminationCriteria, Pruner pruner, SplitPreprocessing preprocessing, LeafCreator leafCreator, boolean noPrePruning, int numberOfPrepruningAlternatives, int minSizeForSplit, int minLeafSize) {
        this.minLeafSizeTerminator = new MinSizeTermination(minLeafSize);
        this.otherTerminators = terminationCriteria;
        this.otherTerminators.add(this.minLeafSizeTerminator);
        this.usePrePruning = !noPrePruning;
        this.numberOfPrepruningAlternatives = Math.max(0, numberOfPrepruningAlternatives);
        this.minSizeForSplit = minSizeForSplit;
        this.leafCreator = leafCreator;
        this.criterion = criterion;
        this.splitter = new NumericalSplitter(this.criterion);
        this.pruner = pruner;
        this.preprocessing = preprocessing;
    }

    public Tree learnTree(ExampleSet exampleSet) throws OperatorException {
        Tree root = new Tree((ExampleSet)exampleSet.clone());
        if (this.shouldStop(exampleSet, 0)) {
            this.leafCreator.changeTreeToLeaf(root, exampleSet);
        } else {
            this.buildTree(root, exampleSet, 1);
        }
        if (this.pruner != null) {
            this.pruner.prune(root);
        }
        return root;
    }

    public Benefit calculateBenefit(ExampleSet trainingSet, Attribute attribute) throws OperatorException {
        if (attribute.isNominal()) {
            return new Benefit(this.criterion.getNominalBenefit(trainingSet, attribute), attribute);
        }
        double splitValue = this.splitter.getBestSplit(trainingSet, attribute);
        if (!Double.isNaN(splitValue)) {
            return new Benefit(this.criterion.getNumericalBenefit(trainingSet, attribute, splitValue), attribute, splitValue);
        }
        return null;
    }

    protected boolean shouldStop(ExampleSet exampleSet, int depth) {
        if (this.usePrePruning && exampleSet.size() < this.minSizeForSplit) {
            return true;
        }
        for (Terminator terminator : this.otherTerminators) {
            if (!terminator.shouldStop(exampleSet, depth)) continue;
            return true;
        }
        return false;
    }

    protected Vector<Benefit> calculateAllBenefits(ExampleSet trainingSet) throws OperatorException {
        Vector<Benefit> benefits = new Vector<Benefit>();
        for (Attribute attribute : trainingSet.getAttributes()) {
            Benefit currentBenefit = this.calculateBenefit(trainingSet, attribute);
            if (currentBenefit == null) continue;
            benefits.add(currentBenefit);
        }
        return benefits;
    }

    protected void buildTree(Tree current, ExampleSet exampleSet, int depth) throws OperatorException {
        if (this.shouldStop(exampleSet, depth)) {
            this.leafCreator.changeTreeToLeaf(current, exampleSet);
            return;
        }
        if (this.preprocessing != null) {
            exampleSet = this.preprocessing.preprocess(exampleSet);
        }
        ExampleSet trainingSet = (ExampleSet)exampleSet.clone();
        Vector<Benefit> benefits = this.calculateAllBenefits(exampleSet);
        Collections.sort(benefits);
        boolean splitFound = false;
        for (int a = 0; a < this.numberOfPrepruningAlternatives + 1 && benefits.size() > 0; ++a) {
            int i;
            Benefit bestBenefit = benefits.remove(0);
            if (this.usePrePruning && bestBenefit.getBenefit() <= 0.0) continue;
            SplittedExampleSet splitted = null;
            Attribute bestAttribute = bestBenefit.getAttribute();
            double bestSplitValue = bestBenefit.getSplitValue();
            splitted = bestAttribute.isNominal() ? SplittedExampleSet.splitByAttribute(trainingSet, bestAttribute) : SplittedExampleSet.splitByAttribute(trainingSet, bestAttribute, bestSplitValue);
            boolean splitOK = true;
            if (this.usePrePruning) {
                for (i = 0; i < splitted.getNumberOfSubsets(); ++i) {
                    splitted.selectSingleSubset(i);
                    if (splitted.size() <= 0 || !this.minLeafSizeTerminator.shouldStop(splitted, depth)) continue;
                    splitOK = false;
                    break;
                }
            }
            if (!splitOK) continue;
            if (bestAttribute.isNominal()) {
                splitted.getAttributes().remove(bestAttribute);
            }
            for (i = 0; i < splitted.getNumberOfSubsets(); ++i) {
                splitted.selectSingleSubset(i);
                if (splitted.size() <= 0) continue;
                Tree child = new Tree((ExampleSet)splitted.clone());
                AbstractSplitCondition condition = null;
                condition = bestAttribute.isNominal() ? new NominalSplitCondition(bestAttribute, splitted.getExample(0).getValueAsString(bestAttribute)) : (i == 0 ? new LessEqualsSplitCondition(bestAttribute, bestSplitValue) : new GreaterSplitCondition(bestAttribute, bestSplitValue));
                current.addChild(child, condition);
                this.buildTree(child, splitted, depth + 1);
            }
            splitFound = true;
            break;
        }
        if (!splitFound) {
            this.leafCreator.changeTreeToLeaf(current, trainingSet);
        }
    }
}

