/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.tree;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCapability;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.learner.CapabilityCheck;
import com.rapidminer.operator.learner.Learner;
import com.rapidminer.operator.learner.tree.Benefit;
import com.rapidminer.operator.learner.tree.DecisionTreeLeafCreator;
import com.rapidminer.operator.learner.tree.EmptyTermination;
import com.rapidminer.operator.learner.tree.MaxDepthTermination;
import com.rapidminer.operator.learner.tree.NoAttributeLeftTermination;
import com.rapidminer.operator.learner.tree.PessimisticPruner;
import com.rapidminer.operator.learner.tree.Pruner;
import com.rapidminer.operator.learner.tree.SingleLabelTermination;
import com.rapidminer.operator.learner.tree.Terminator;
import com.rapidminer.operator.learner.tree.Tree;
import com.rapidminer.operator.learner.tree.TreeBuilder;
import com.rapidminer.operator.learner.tree.TreeModel;
import com.rapidminer.operator.learner.tree.criterions.GainRatioCriterion;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.GenerateNewMDRule;
import com.rapidminer.operator.ports.metadata.LearnerPrecondition;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.PassThroughRule;
import com.rapidminer.operator.ports.metadata.SimplePrecondition;
import com.rapidminer.operator.ports.metadata.SubprocessTransformRule;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeNumber;
import com.rapidminer.tools.Tools;
import java.util.LinkedList;
import java.util.List;

public class RelevanceTreeLearner
extends OperatorChain
implements Learner {
    protected final InputPort exampleSetInput = (InputPort)this.getInputPorts().createPort("training set");
    private final OutputPort innerExampleSource = (OutputPort)this.getSubprocess(0).getInnerSources().createPort("training set");
    private final InputPort weightsInnerSink = (InputPort)this.getSubprocess(0).getInnerSinks().createPort("weights");
    private final OutputPort modelOutput = (OutputPort)this.getOutputPorts().createPort("model");

    public RelevanceTreeLearner(OperatorDescription description) {
        super(description, "Weighting");
        this.exampleSetInput.addPrecondition(new LearnerPrecondition(this, this.exampleSetInput));
        this.getTransformer().addRule(new PassThroughRule(this.exampleSetInput, this.innerExampleSource, true));
        this.getTransformer().addRule(new SubprocessTransformRule(this.getSubprocess(0)));
        this.weightsInnerSink.addPrecondition(new SimplePrecondition(this.weightsInnerSink, new MetaData(AttributeWeights.class), false));
        this.getTransformer().addRule(new GenerateNewMDRule(this.modelOutput, TreeModel.class));
    }

    @Override
    public void doWork() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        if (exampleSet.getAttributes().getLabel() == null) {
            throw new UserError((Operator)this, 105, new Object[0]);
        }
        if (exampleSet.getAttributes().size() == 0) {
            throw new UserError((Operator)this, 106, new Object[0]);
        }
        CapabilityCheck check = new CapabilityCheck(this, Tools.booleanValue(System.getProperty("rapidminer.general.capabilities.warn"), true));
        check.checkLearnerCapabilities(this, exampleSet);
        Model model = this.learn(exampleSet);
        this.modelOutput.deliver(model);
    }

    @Override
    public Model learn(ExampleSet exampleSet) throws OperatorException {
        TreeBuilder builder = new TreeBuilder(new GainRatioCriterion(0.0), this.getTerminationCriteria(exampleSet), this.getPruner(), null, new DecisionTreeLeafCreator(), this.getParameterAsBoolean("no_pre_pruning"), this.getParameterAsInt("number_of_prepruning_alternatives"), this.getParameterAsInt("minimal_size_for_split"), this.getParameterAsInt("minimal_leaf_size")){

            @Override
            public Benefit calculateBenefit(ExampleSet exampleSet, Attribute attribute) throws OperatorException {
                return RelevanceTreeLearner.this.calculateBenefit(exampleSet, attribute);
            }
        };
        Tree root = builder.learnTree(exampleSet);
        return new TreeModel(exampleSet, root);
    }

    protected void applyInnerLearner(ExampleSet exampleSet) throws OperatorException {
        this.innerExampleSource.deliver(exampleSet);
        this.executeInnerLearner();
    }

    protected void executeInnerLearner() throws OperatorException {
        this.getSubprocess(0).execute();
    }

    protected Benefit calculateBenefit(ExampleSet exampleSet, Attribute attribute) throws OperatorException {
        ExampleSet trainingSet = (ExampleSet)exampleSet.clone();
        double weight = Double.NaN;
        if (this.weightsInnerSink.isConnected()) {
            this.applyInnerLearner(trainingSet);
            AttributeWeights weights = (AttributeWeights)this.weightsInnerSink.getData();
            weight = weights.getWeight(attribute.getName());
        } else {
            this.getLogger().info("Weight not connected. Skipping");
        }
        if (!Double.isNaN(weight)) {
            return new Benefit(weight, attribute);
        }
        return null;
    }

    public Pruner getPruner() throws OperatorException {
        if (!this.getParameterAsBoolean("no_pruning")) {
            return new PessimisticPruner(this.getParameterAsDouble("confidence"), new DecisionTreeLeafCreator());
        }
        return null;
    }

    public List<Terminator> getTerminationCriteria(ExampleSet exampleSet) throws OperatorException {
        LinkedList<Terminator> result = new LinkedList<Terminator>();
        result.add(new SingleLabelTermination());
        result.add(new NoAttributeLeftTermination());
        result.add(new EmptyTermination());
        int maxDepth = this.getParameterAsInt("maximal_depth");
        if (maxDepth <= 0) {
            maxDepth = exampleSet.size();
        }
        result.add(new MaxDepthTermination(maxDepth));
        return result;
    }

    @Override
    public boolean supportsCapability(OperatorCapability capability) {
        if (capability == OperatorCapability.BINOMINAL_ATTRIBUTES) {
            return true;
        }
        if (capability == OperatorCapability.POLYNOMINAL_ATTRIBUTES) {
            return true;
        }
        if (capability == OperatorCapability.POLYNOMINAL_LABEL) {
            return true;
        }
        if (capability == OperatorCapability.BINOMINAL_LABEL) {
            return true;
        }
        return capability == OperatorCapability.WEIGHTED_EXAMPLES;
    }

    @Override
    public PerformanceVector getEstimatedPerformance() throws OperatorException {
        throw new UserError((Operator)this, 912, this.getName(), "estimation of performance not supported.");
    }

    @Override
    public AttributeWeights getWeights(ExampleSet eSet) throws OperatorException {
        throw new UserError((Operator)this, 916, this.getName(), "calculation of weights not supported.");
    }

    @Override
    public boolean shouldCalculateWeights() {
        return false;
    }

    @Override
    public boolean shouldEstimatePerformance() {
        return false;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeNumber type = new ParameterTypeInt("minimal_size_for_split", "The minimal size of a node in order to allow a split.", 1, Integer.MAX_VALUE, 4);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt("minimal_leaf_size", "The minimal size of all leaves.", 1, Integer.MAX_VALUE, 2);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt("maximal_depth", "The maximum tree depth (-1: no bound)", -1, Integer.MAX_VALUE, 10);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("confidence", "The confidence level used for pruning.", 1.0E-7, 0.5, 0.25);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeBoolean("no_pruning", "Disables the pruning and delivers an unpruned tree.", false));
        types.add(new ParameterTypeInt("number_of_prepruning_alternatives", "The number of alternative nodes tried when prepruning would prevent a split.", 0, Integer.MAX_VALUE, 3));
        return types;
    }
}

