/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.tree;

import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.learner.tree.DecisionTreeLearner;
import com.rapidminer.operator.learner.tree.RandomSubsetPreprocessing;
import com.rapidminer.operator.learner.tree.SplitPreprocessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.tools.RandomGenerator;
import java.util.List;

public class RandomTreeLearner
extends DecisionTreeLearner {
    public static final String PARAMETER_USE_HEURISTIC_SUBSET_RATION = "guess_subset_ratio";
    public static final String PARAMETER_SUBSET_RATIO = "subset_ratio";

    public RandomTreeLearner(OperatorDescription description) {
        super(description);
    }

    @Override
    public SplitPreprocessing getSplitPreprocessing() {
        RandomSubsetPreprocessing preprocessing = null;
        try {
            preprocessing = new RandomSubsetPreprocessing(this.getParameterAsBoolean(PARAMETER_USE_HEURISTIC_SUBSET_RATION), this.getParameterAsDouble(PARAMETER_SUBSET_RATIO), RandomGenerator.getRandomGenerator(this.getParameterAsBoolean("use_local_random_seed"), this.getParameterAsInt("local_random_seed")));
        }
        catch (UndefinedParameterError undefinedParameterError) {
            // empty catch block
        }
        return preprocessing;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeBoolean(PARAMETER_USE_HEURISTIC_SUBSET_RATION, "Indicates that log(m) + 1 features are used, otherwise a ratio has to be specified.", true);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_SUBSET_RATIO, "Ratio of randomly chosen attributes to test", 0.0, 1.0, 0.2);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_USE_HEURISTIC_SUBSET_RATION, false, false));
        type.setExpert(false);
        types.add(type);
        types.addAll(RandomGenerator.getRandomGeneratorParameters(this));
        return types;
    }
}

