/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.tree;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.SortedExampleSet;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.tree.criterions.Criterion;
import com.rapidminer.tools.Tools;
import java.util.Iterator;

public class NumericalSplitter {
    private Criterion criterion;

    public NumericalSplitter(Criterion criterion) {
        this.criterion = criterion;
    }

    public double getBestSplit(ExampleSet inputSet, Attribute attribute) throws OperatorException {
        SortedExampleSet exampleSet = new SortedExampleSet((ExampleSet)inputSet.clone(), attribute, 0);
        Attribute labelAttribute = exampleSet.getAttributes().getLabel();
        double oldLabel = Double.NaN;
        double bestSplit = Double.NaN;
        double lastValue = Double.NaN;
        double bestSplitBenefit = Double.NEGATIVE_INFINITY;
        Example lastExample = null;
        if (this.criterion.supportsIncrementalCalculation()) {
            this.criterion.startIncrementalCalculation(exampleSet);
        }
        Iterator<Example> exampleIterator = exampleSet.iterator();
        while (exampleIterator.hasNext()) {
            Example e = exampleIterator.next();
            boolean isLast = !exampleIterator.hasNext();
            double currentValue = e.getValue(attribute);
            double label = e.getValue(labelAttribute);
            if (this.criterion.supportsIncrementalCalculation()) {
                if (lastExample != null) {
                    this.criterion.swapExample(lastExample);
                }
                lastExample = e;
                if ((Double.isNaN(oldLabel) || oldLabel != label || isLast) && (!Tools.isEqual(currentValue, lastValue) || isLast)) {
                    double benefit = this.criterion.getIncrementalBenefit();
                    if (benefit > bestSplitBenefit) {
                        bestSplitBenefit = benefit;
                        bestSplit = (lastValue + currentValue) / 2.0;
                    }
                    oldLabel = label;
                }
            } else if ((Double.isNaN(oldLabel) || oldLabel != label) && !Tools.isEqual(currentValue, lastValue)) {
                double splitValue = (lastValue + currentValue) / 2.0;
                double benefit = this.criterion.getNumericalBenefit(exampleSet, attribute, splitValue);
                if (benefit > bestSplitBenefit) {
                    bestSplitBenefit = benefit;
                    bestSplit = splitValue;
                }
                oldLabel = label;
            }
            lastValue = currentValue;
        }
        return bestSplit;
    }
}

