/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.tree;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.GroupedModel;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCapability;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.learner.meta.AbstractMetaLearner;
import com.rapidminer.operator.learner.tree.Edge;
import com.rapidminer.operator.learner.tree.GreaterSplitCondition;
import com.rapidminer.operator.learner.tree.LessEqualsSplitCondition;
import com.rapidminer.operator.learner.tree.SplitCondition;
import com.rapidminer.operator.learner.tree.Tree;
import com.rapidminer.operator.learner.tree.TreeModel;
import com.rapidminer.operator.preprocessing.PreprocessingOperator;
import com.rapidminer.operator.preprocessing.discretization.UserBasedDiscretization;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.container.Pair;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class MultiwayDecisionTree
extends AbstractMetaLearner {
    public MultiwayDecisionTree(OperatorDescription description) {
        super(description);
    }

    @Override
    public Model learn(ExampleSet exampleSet) throws OperatorException {
        GroupedModel groupedModel = new GroupedModel();
        TreeModel model = (TreeModel)this.applyInnerLearner(exampleSet);
        HashMap<String, List<Double>> attributePointMap = new HashMap<String, List<Double>>();
        this.addNodeSplitPoints(model.getRoot(), attributePointMap);
        try {
            PreprocessingOperator userbasedDiscretization = OperatorService.createOperator(UserBasedDiscretization.class);
            userbasedDiscretization.setParameter("attribute_filter_type", "3");
            userbasedDiscretization.setParameter("return_preprocessing_model", "true");
            for (Map.Entry currentAttribute : attributePointMap.entrySet()) {
                String[] pointSpecifier;
                double[] splitPoints = new double[((List)currentAttribute.getValue()).size()];
                int i = 0;
                for (Double splitPoint : (List)attributePointMap.get(currentAttribute)) {
                    splitPoints[i] = splitPoint;
                    ++i;
                }
                Arrays.sort(splitPoints);
                userbasedDiscretization.setParameter("regular_expression", (String)currentAttribute.getKey());
                LinkedList<String[]> borders = new LinkedList<String[]>();
                double lowerBorder = Double.NEGATIVE_INFINITY;
                for (i = 0; i < splitPoints.length; ++i) {
                    pointSpecifier = new String[]{currentAttribute + " in " + Tools.formatNumber(lowerBorder, 2) + " to " + Tools.formatNumber(splitPoints[i], 2), splitPoints[i] + ""};
                    lowerBorder = splitPoints[i];
                    borders.add(pointSpecifier);
                }
                pointSpecifier = new String[]{currentAttribute + " in " + Tools.formatNumber(lowerBorder, 2) + " to " + Tools.formatNumber(Double.POSITIVE_INFINITY, 2), "Infinity"};
                borders.add(pointSpecifier);
                userbasedDiscretization.setParameter("classes", ParameterTypeList.transformList2String(borders));
                Pair<ExampleSet, Model> result = userbasedDiscretization.doWorkModel(exampleSet);
                exampleSet = result.getFirst();
                groupedModel.addModel(result.getSecond());
            }
            groupedModel.addModel(this.applyInnerLearner(exampleSet));
            return groupedModel;
        }
        catch (OperatorCreationException e) {
            throw new UserError((Operator)this, 904, "operators", e.getMessage());
        }
    }

    private void addNodeSplitPoints(Tree root, Map<String, List<Double>> attributePointMap) {
        if (!root.isLeaf()) {
            SplitCondition condition = root.childIterator().next().getCondition();
            if (condition instanceof GreaterSplitCondition) {
                this.addSplit(condition.getAttributeName(), ((GreaterSplitCondition)condition).getValue(), attributePointMap);
            } else if (condition instanceof LessEqualsSplitCondition) {
                this.addSplit(condition.getAttributeName(), ((LessEqualsSplitCondition)condition).getValue(), attributePointMap);
            }
        }
        Iterator<Edge> iterator = root.childIterator();
        while (iterator.hasNext()) {
            this.addNodeSplitPoints(iterator.next().getChild(), attributePointMap);
        }
    }

    private void addSplit(String attributeName, double value, Map<String, List<Double>> attributePointMap) {
        List<Double> valueList = attributePointMap.get(attributeName);
        if (valueList == null) {
            valueList = new LinkedList<Double>();
            attributePointMap.put(attributeName, valueList);
        }
        valueList.add(value);
    }

    @Override
    public boolean supportsCapability(OperatorCapability capability) {
        switch (capability) {
            case BINOMINAL_ATTRIBUTES: 
            case POLYNOMINAL_ATTRIBUTES: 
            case NUMERICAL_ATTRIBUTES: 
            case POLYNOMINAL_LABEL: 
            case BINOMINAL_LABEL: 
            case WEIGHTED_EXAMPLES: 
            case MISSING_VALUES: {
                return true;
            }
        }
        return false;
    }
}

