/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.tree;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorCapability;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.tree.AbstractTreeLearner;
import com.rapidminer.operator.learner.tree.DecisionTreeLeafCreator;
import com.rapidminer.operator.learner.tree.EmptyTermination;
import com.rapidminer.operator.learner.tree.MaxDepthTermination;
import com.rapidminer.operator.learner.tree.NoAttributeLeftTermination;
import com.rapidminer.operator.learner.tree.Pruner;
import com.rapidminer.operator.learner.tree.SingleLabelTermination;
import com.rapidminer.operator.learner.tree.Terminator;
import com.rapidminer.operator.learner.tree.TreeBuilder;
import java.util.LinkedList;
import java.util.List;

public class ID3NumericalLearner
extends AbstractTreeLearner {
    public ID3NumericalLearner(OperatorDescription description) {
        super(description);
    }

    @Override
    public Pruner getPruner() throws OperatorException {
        return null;
    }

    @Override
    public List<Terminator> getTerminationCriteria(ExampleSet exampleSet) {
        LinkedList<Terminator> result = new LinkedList<Terminator>();
        result.add(new SingleLabelTermination());
        result.add(new NoAttributeLeftTermination());
        result.add(new EmptyTermination());
        result.add(new MaxDepthTermination(exampleSet.size()));
        return result;
    }

    @Override
    public boolean supportsCapability(OperatorCapability capability) {
        switch (capability) {
            case BINOMINAL_ATTRIBUTES: 
            case POLYNOMINAL_ATTRIBUTES: 
            case NUMERICAL_ATTRIBUTES: 
            case POLYNOMINAL_LABEL: 
            case BINOMINAL_LABEL: 
            case WEIGHTED_EXAMPLES: 
            case MISSING_VALUES: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected TreeBuilder getTreeBuilder(ExampleSet exampleSet) throws OperatorException {
        return new TreeBuilder(this.createCriterion(this.getParameterAsDouble("minimal_gain")), this.getTerminationCriteria(exampleSet), this.getPruner(), this.getSplitPreprocessing(), new DecisionTreeLeafCreator(), true, 0, this.getParameterAsInt("minimal_size_for_split"), this.getParameterAsInt("minimal_leaf_size"));
    }
}

