/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.tree;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.SplittedExampleSet;
import com.rapidminer.tools.Tools;

public class FrequencyCalculator {
    public double[][] getNumericalWeightCounts(ExampleSet exampleSet, Attribute attribute, double splitValue) {
        Attribute label = exampleSet.getAttributes().getLabel();
        int numberOfLabels = label.getMapping().size();
        Attribute weightAttribute = exampleSet.getAttributes().getWeight();
        double[][] weightCounts = new double[2][numberOfLabels];
        for (Example example : exampleSet) {
            int labelIndex = (int)example.getValue(label);
            double value = example.getValue(attribute);
            double weight = 1.0;
            if (weightAttribute != null) {
                weight = example.getValue(weightAttribute);
            }
            if (Tools.isLessEqual(value, splitValue)) {
                double[] dArray = weightCounts[0];
                int n = labelIndex;
                dArray[n] = dArray[n] + weight;
                continue;
            }
            double[] dArray = weightCounts[1];
            int n = labelIndex;
            dArray[n] = dArray[n] + weight;
        }
        return weightCounts;
    }

    public double[][] getNominalWeightCounts(ExampleSet exampleSet, Attribute attribute) {
        Attribute label = exampleSet.getAttributes().getLabel();
        int numberOfLabels = label.getMapping().size();
        int numberOfValues = attribute.getMapping().size();
        Attribute weightAttribute = exampleSet.getAttributes().getWeight();
        double[][] weightCounts = new double[numberOfValues][numberOfLabels];
        for (Example example : exampleSet) {
            int labelIndex = (int)example.getValue(label);
            double value = example.getValue(attribute);
            if (Double.isNaN(value)) continue;
            int valueIndex = (int)value;
            double weight = 1.0;
            if (weightAttribute != null) {
                weight = example.getValue(weightAttribute);
            }
            double[] dArray = weightCounts[valueIndex];
            int n = labelIndex;
            dArray[n] = dArray[n] + weight;
        }
        return weightCounts;
    }

    public double[] getPartitionWeights(SplittedExampleSet splitted) {
        Attribute weightAttribute = splitted.getAttributes().getWeight();
        double[] weights = new double[splitted.getNumberOfSubsets()];
        for (int i = 0; i < splitted.getNumberOfSubsets(); ++i) {
            splitted.selectSingleSubset(i);
            for (Example e : splitted) {
                double weight = 1.0;
                if (weightAttribute != null) {
                    weight = e.getValue(weightAttribute);
                }
                int n = i;
                weights[n] = weights[n] + weight;
            }
        }
        return weights;
    }

    public double[] getLabelWeights(ExampleSet exampleSet) {
        Attribute label = exampleSet.getAttributes().getLabel();
        Attribute weightAttribute = exampleSet.getAttributes().getWeight();
        double[] weights = new double[label.getMapping().size()];
        for (Example e : exampleSet) {
            int labelIndex = (int)e.getValue(label);
            double weight = 1.0;
            if (weightAttribute != null) {
                weight = e.getValue(weightAttribute);
            }
            int n = labelIndex;
            weights[n] = weights[n] + weight;
        }
        return weights;
    }

    public double getTotalWeight(double[] weights) {
        double sum = 0.0;
        for (double w : weights) {
            sum += w;
        }
        return sum;
    }
}

