/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.tree;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorCapability;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.tree.AbstractTreeLearner;
import com.rapidminer.operator.learner.tree.DecisionTreeLeafCreator;
import com.rapidminer.operator.learner.tree.EmptyTermination;
import com.rapidminer.operator.learner.tree.MaxDepthTermination;
import com.rapidminer.operator.learner.tree.NoAttributeLeftTermination;
import com.rapidminer.operator.learner.tree.PessimisticPruner;
import com.rapidminer.operator.learner.tree.Pruner;
import com.rapidminer.operator.learner.tree.SingleLabelTermination;
import com.rapidminer.operator.learner.tree.Terminator;
import com.rapidminer.operator.learner.tree.TreeBuilder;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeNumber;
import java.util.LinkedList;
import java.util.List;

public class DecisionTreeLearner
extends AbstractTreeLearner {
    public static final String PARAMETER_MAXIMAL_DEPTH = "maximal_depth";
    public static final String PARAMETER_CONFIDENCE = "confidence";
    public static final String PARAMETER_NO_PRUNING = "no_pruning";
    public static final String PARAMETER_NO_PRE_PRUNING = "no_pre_pruning";
    public static final String PARAMETER_NUMBER_OF_PREPRUNING_ALTERNATIVES = "number_of_prepruning_alternatives";

    public DecisionTreeLearner(OperatorDescription description) {
        super(description);
    }

    @Override
    public Pruner getPruner() throws OperatorException {
        if (!this.getParameterAsBoolean(PARAMETER_NO_PRUNING)) {
            return new PessimisticPruner(this.getParameterAsDouble(PARAMETER_CONFIDENCE), new DecisionTreeLeafCreator());
        }
        return null;
    }

    @Override
    public List<Terminator> getTerminationCriteria(ExampleSet exampleSet) throws OperatorException {
        LinkedList<Terminator> result = new LinkedList<Terminator>();
        result.add(new SingleLabelTermination());
        result.add(new NoAttributeLeftTermination());
        result.add(new EmptyTermination());
        int maxDepth = this.getParameterAsInt(PARAMETER_MAXIMAL_DEPTH);
        if (maxDepth <= 0) {
            maxDepth = exampleSet.size();
        }
        result.add(new MaxDepthTermination(maxDepth));
        return result;
    }

    @Override
    public boolean supportsCapability(OperatorCapability capability) {
        switch (capability) {
            case BINOMINAL_ATTRIBUTES: 
            case POLYNOMINAL_ATTRIBUTES: 
            case NUMERICAL_ATTRIBUTES: 
            case POLYNOMINAL_LABEL: 
            case BINOMINAL_LABEL: 
            case MISSING_VALUES: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected TreeBuilder getTreeBuilder(ExampleSet exampleSet) throws OperatorException {
        return new TreeBuilder(this.createCriterion(this.getParameterAsDouble("minimal_gain")), this.getTerminationCriteria(exampleSet), this.getPruner(), this.getSplitPreprocessing(), new DecisionTreeLeafCreator(), this.getParameterAsBoolean(PARAMETER_NO_PRE_PRUNING), this.getParameterAsInt(PARAMETER_NUMBER_OF_PREPRUNING_ALTERNATIVES), this.getParameterAsInt("minimal_size_for_split"), this.getParameterAsInt("minimal_leaf_size"));
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeNumber type = new ParameterTypeInt(PARAMETER_MAXIMAL_DEPTH, "The maximum tree depth (-1: no bound)", -1, Integer.MAX_VALUE, 20);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_CONFIDENCE, "The confidence level used for the pessimistic error calculation of pruning.", 1.0E-7, 0.5, 0.25);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeInt(PARAMETER_NUMBER_OF_PREPRUNING_ALTERNATIVES, "The number of alternative nodes tried when prepruning would prevent a split.", 0, Integer.MAX_VALUE, 3));
        types.add(new ParameterTypeBoolean(PARAMETER_NO_PRE_PRUNING, "Disables the pre pruning and delivers a tree without any prepruning.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_NO_PRUNING, "Disables the pruning and delivers an unpruned tree.", false));
        return types;
    }
}

