/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.tree;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorCapability;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.features.weighting.ChiSquaredWeighting;
import com.rapidminer.operator.learner.tree.Benefit;
import com.rapidminer.operator.learner.tree.DecisionTreeLearner;
import com.rapidminer.operator.learner.tree.criterions.Criterion;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.tools.OperatorService;
import java.util.Iterator;
import java.util.List;

public class CHAIDLearner
extends DecisionTreeLearner {
    public CHAIDLearner(OperatorDescription description) {
        super(description);
    }

    @Override
    protected Criterion createCriterion(double minimalGain) throws OperatorException {
        return new Criterion(){

            @Override
            public double getIncrementalBenefit() {
                throw new UnsupportedOperationException("Incremental calculation not supported.");
            }

            @Override
            public double getNominalBenefit(ExampleSet exampleSet, Attribute attribute) throws OperatorException {
                exampleSet = (ExampleSet)exampleSet.clone();
                exampleSet.getAttributes().clearRegular();
                exampleSet.getAttributes().addRegular(attribute);
                CHAIDLearner.this.getLogger().info("Calc benefit for: " + exampleSet);
                ChiSquaredWeighting weightOp = null;
                try {
                    weightOp = OperatorService.createOperator(ChiSquaredWeighting.class);
                }
                catch (OperatorCreationException e) {
                    throw new OperatorException("Cannot create chi squared calculation operator.", e);
                }
                AttributeWeights weights = weightOp.doWork(exampleSet);
                CHAIDLearner.this.getLogger().info("Weights are: " + weights);
                for (String w : weights.getAttributeNames()) {
                    CHAIDLearner.this.getLogger().info("W(" + w + ")=" + weights.getWeight(w));
                }
                return weights.getWeight(attribute.getName());
            }

            @Override
            public double getNumericalBenefit(ExampleSet exampleSet, Attribute attribute, double splitValue) {
                throw new UnsupportedOperationException("Numerical attributes not supported.");
            }

            @Override
            public void startIncrementalCalculation(ExampleSet exampleSet) {
                throw new UnsupportedOperationException("Incremental calculation not supported.");
            }

            @Override
            public boolean supportsIncrementalCalculation() {
                return false;
            }

            @Override
            public void swapExample(Example example) {
                throw new UnsupportedOperationException("Incremental calculation not supported.");
            }

            @Override
            public double getBenefit(double[][] weightCounts) {
                throw new UnsupportedOperationException("Method not supported.");
            }
        };
    }

    protected Benefit calculateBenefit(ExampleSet trainingSet, Attribute attribute) throws OperatorException {
        ChiSquaredWeighting weightOp = null;
        try {
            weightOp = OperatorService.createOperator(ChiSquaredWeighting.class);
        }
        catch (OperatorCreationException e) {
            this.getLogger().warning("Cannot create chi squared calculation operator.");
            return null;
        }
        double weight = Double.NaN;
        if (weightOp != null) {
            AttributeWeights weights = weightOp.doWork(trainingSet);
            weight = weights.getWeight(attribute.getName());
        }
        if (!Double.isNaN(weight)) {
            return new Benefit(weight, attribute);
        }
        return null;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        Iterator<ParameterType> i = types.iterator();
        while (i.hasNext()) {
            if (!i.next().getKey().equals("criterion")) continue;
            i.remove();
        }
        return types;
    }

    @Override
    public boolean supportsCapability(OperatorCapability capability) {
        if (capability == OperatorCapability.NUMERICAL_ATTRIBUTES) {
            return false;
        }
        return super.supportsCapability(capability);
    }
}

