/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.tree;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.AbstractLearner;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.operator.learner.tree.Pruner;
import com.rapidminer.operator.learner.tree.SplitPreprocessing;
import com.rapidminer.operator.learner.tree.Terminator;
import com.rapidminer.operator.learner.tree.Tree;
import com.rapidminer.operator.learner.tree.TreeBuilder;
import com.rapidminer.operator.learner.tree.TreeModel;
import com.rapidminer.operator.learner.tree.criterions.AbstractCriterion;
import com.rapidminer.operator.learner.tree.criterions.AccuracyCriterion;
import com.rapidminer.operator.learner.tree.criterions.Criterion;
import com.rapidminer.operator.learner.tree.criterions.GainRatioCriterion;
import com.rapidminer.operator.learner.tree.criterions.GiniIndexCriterion;
import com.rapidminer.operator.learner.tree.criterions.InfoGainCriterion;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.ParameterTypeStringCategory;
import java.util.List;

public abstract class AbstractTreeLearner
extends AbstractLearner {
    public static final String PARAMETER_CRITERION = "criterion";
    public static final String PARAMETER_MINIMAL_SIZE_FOR_SPLIT = "minimal_size_for_split";
    public static final String PARAMETER_MINIMAL_LEAF_SIZE = "minimal_leaf_size";
    public static final String PARAMETER_MINIMAL_GAIN = "minimal_gain";
    public static final String[] CRITERIA_NAMES = new String[]{"gain_ratio", "information_gain", "gini_index", "accuracy"};
    public static final Class[] CRITERIA_CLASSES = new Class[]{GainRatioCriterion.class, InfoGainCriterion.class, GiniIndexCriterion.class, AccuracyCriterion.class};
    public static final int CRITERION_GAIN_RATIO = 0;
    public static final int CRITERION_INFO_GAIN = 1;
    public static final int CRITERION_GINI_INDEX = 2;
    public static final int CRITERION_ACCURACY = 3;

    public AbstractTreeLearner(OperatorDescription description) {
        super(description);
    }

    @Override
    public Class<? extends PredictionModel> getModelClass() {
        return TreeModel.class;
    }

    public abstract List<Terminator> getTerminationCriteria(ExampleSet var1) throws OperatorException;

    public abstract Pruner getPruner() throws OperatorException;

    public SplitPreprocessing getSplitPreprocessing() {
        return null;
    }

    @Override
    public Model learn(ExampleSet eSet) throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)eSet.clone();
        TreeBuilder builder = this.getTreeBuilder(exampleSet);
        Tree root = builder.learnTree(exampleSet);
        return new TreeModel(exampleSet, root);
    }

    protected abstract TreeBuilder getTreeBuilder(ExampleSet var1) throws OperatorException;

    protected Criterion createCriterion(double minimalGain) throws OperatorException {
        return AbstractCriterion.createCriterion(this, minimalGain);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeStringCategory(PARAMETER_CRITERION, "Specifies the used criterion for selecting attributes and numerical splits.", CRITERIA_NAMES, CRITERIA_NAMES[0], false);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_MINIMAL_SIZE_FOR_SPLIT, "The minimal size of a node in order to allow a split.", 1, Integer.MAX_VALUE, 4);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_MINIMAL_LEAF_SIZE, "The minimal size of all leaves.", 1, Integer.MAX_VALUE, 2);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeDouble(PARAMETER_MINIMAL_GAIN, "The minimal gain which must be achieved in order to produce a split.", 0.0, Double.POSITIVE_INFINITY, 0.1));
        return types;
    }
}

