/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.subgroups.utility;

import com.rapidminer.operator.learner.subgroups.hypothesis.Hypothesis;
import com.rapidminer.operator.learner.subgroups.hypothesis.Rule;
import com.rapidminer.operator.learner.subgroups.utility.UtilityFunction;

public class OddsRatio
extends UtilityFunction {
    public OddsRatio(double totalWeight, double totalPositiveWeight) {
        super(totalWeight, totalPositiveWeight);
    }

    @Override
    public double utility(Rule rule) {
        double totalPredictionWeight = rule.predictsPositive() ? this.totalPositiveWeight : this.totalNegativeWeight;
        double nominator = rule.getPredictionWeight() * (this.totalWeight - totalPredictionWeight - rule.getCoveredWeight() + rule.getPredictionWeight());
        double denominator = (this.totalWeight - rule.getCoveredWeight()) * (this.totalWeight - totalPredictionWeight);
        return nominator / denominator;
    }

    @Override
    public double optimisticEstimate(Hypothesis hypothesis) {
        return 2.147483647E9;
    }

    @Override
    public String getName() {
        return "Odds Ratio";
    }

    @Override
    public String getAbbreviation() {
        return "OR";
    }
}

