/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.subgroups.utility;

import com.rapidminer.operator.learner.subgroups.hypothesis.Hypothesis;
import com.rapidminer.operator.learner.subgroups.hypothesis.Rule;
import com.rapidminer.operator.learner.subgroups.utility.UtilityFunction;

public class Accuracy
extends UtilityFunction {
    public Accuracy(double totalWeight, double totalPositiveWeight) {
        super(totalWeight, totalPositiveWeight);
    }

    @Override
    public double utility(Rule rule) {
        double totalPredictionWeight = rule.predictsPositive() ? this.totalPositiveWeight : this.totalNegativeWeight;
        return (this.totalWeight - totalPredictionWeight - rule.getCoveredWeight() + 2.0 * rule.getPredictionWeight()) / this.totalWeight;
    }

    @Override
    public double optimisticEstimate(Hypothesis hypothesis) {
        return 1.0;
    }

    @Override
    public String getName() {
        return "Accuracy";
    }

    @Override
    public String getAbbreviation() {
        return "Acc";
    }
}

