/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.subgroups.hypothesis;

import com.rapidminer.example.Example;
import com.rapidminer.operator.learner.subgroups.hypothesis.Hypothesis;
import com.rapidminer.operator.learner.subgroups.hypothesis.Literal;
import com.rapidminer.operator.learner.subgroups.utility.UtilityFunction;
import com.rapidminer.tools.Tools;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;

public class Rule
implements Serializable {
    private static final long serialVersionUID = 1L;
    Hypothesis hypothesis;
    Literal prediction;
    LinkedHashMap<UtilityFunction, Double> utilityMap = new LinkedHashMap();

    public Rule(Hypothesis hypothesis, Literal prediction) {
        this.hypothesis = hypothesis;
        this.prediction = prediction;
    }

    public boolean applicable(Example example) {
        return this.hypothesis.applicable(example);
    }

    public double getCoveredWeight() {
        return this.hypothesis.getCoveredWeight();
    }

    public double getPositiveWeight() {
        return this.hypothesis.getPositiveWeight();
    }

    public double getNegativeWeight() {
        return this.hypothesis.getCoveredWeight() - this.hypothesis.getPositiveWeight();
    }

    public double getPredictionWeight() {
        if (this.predictsPositive()) {
            return this.getPositiveWeight();
        }
        return this.getNegativeWeight();
    }

    public boolean predictsPositive() {
        return this.prediction.getValue() == (double)this.prediction.getAttribute().getMapping().getPositiveIndex();
    }

    public double getPrediction() {
        return this.prediction.getValue();
    }

    public Hypothesis getHypothesis() {
        return this.hypothesis;
    }

    public void setUtility(UtilityFunction function, double utility) {
        this.utilityMap.put(function, utility);
    }

    public double getUtility(Class<? extends UtilityFunction> functionClass) {
        for (UtilityFunction function : this.utilityMap.keySet()) {
            if (!function.getClass().equals(functionClass)) continue;
            return this.utilityMap.get(function);
        }
        return Double.NaN;
    }

    public UtilityFunction getUtilityFunction(Class<? extends UtilityFunction> functionClass) {
        for (UtilityFunction function : this.utilityMap.keySet()) {
            if (!function.getClass().equals(functionClass)) continue;
            return function;
        }
        return null;
    }

    public Collection<UtilityFunction> getUtilityFunctions() {
        return this.utilityMap.keySet();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Rule otherRule = (Rule)object;
        return this.hypothesis.equals(otherRule.hypothesis) && this.prediction.equals(otherRule.prediction);
    }

    private String utilityString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        stringBuffer.append("Pos=" + this.getPositiveWeight() + ", ");
        stringBuffer.append("Neg=" + this.getNegativeWeight() + ", ");
        stringBuffer.append("Size=" + this.getCoveredWeight() + ", ");
        for (UtilityFunction function : this.utilityMap.keySet()) {
            stringBuffer.append(function.getAbbreviation() + "=" + Tools.formatIntegerIfPossible(this.utilityMap.get(function)) + ", ");
        }
        stringBuffer.subSequence(0, stringBuffer.length() - 2);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String toStringScored() {
        return this.toString() + "  " + this.utilityString();
    }

    public String toString() {
        return this.hypothesis + " --> " + this.prediction;
    }

    public Hypothesis getPremise() {
        return this.hypothesis;
    }

    public Literal getConclusion() {
        return this.prediction;
    }
}

