/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.subgroups.hypothesis;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import java.io.Serializable;

public class Literal
implements Serializable {
    private static final long serialVersionUID = 8699112785374243323L;
    private Attribute attribute = null;
    private double value = 0.0;

    public Literal(Attribute attribute, double value) {
        this.attribute = attribute;
        this.value = value;
    }

    public boolean applicable(Example example) {
        return example.getValue(this.attribute) == this.value;
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public double getValue() {
        return this.value;
    }

    public String getValueAsString() {
        return this.attribute.getMapping().mapIndex((int)this.value);
    }

    public int hashCode() {
        return ((Object)this.attribute).hashCode() ^ Integer.valueOf((int)this.value);
    }

    public boolean contradicts(Literal otherLiteral) {
        return ((Object)this.attribute).equals(otherLiteral.attribute) && this.value != otherLiteral.value;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Literal otherLiteral = (Literal)object;
        return ((Object)this.attribute).equals(otherLiteral.attribute) && this.value == otherLiteral.value;
    }

    public String toString() {
        return this.attribute.getName() + "=" + this.attribute.getMapping().mapIndex((int)this.value);
    }
}

