/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.subgroups.hypothesis;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.operator.learner.subgroups.hypothesis.Literal;
import com.rapidminer.operator.learner.subgroups.hypothesis.Rule;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;

public class Hypothesis
implements Serializable {
    private static final long serialVersionUID = 8694312785374243323L;
    public static final int POSITIVE_RULE = 0;
    public static final int NEGATIVE_RULE = 1;
    public static final int PREDICTION_RULE = 2;
    public static final int POSITIVE_AND_NEGATIVE_RULES = 3;
    public static final String[] RULE_GENERATION_MODES = new String[]{"positive", "negative", "prediction", "both"};
    private LinkedHashMap<Attribute, Literal> literalMap = new LinkedHashMap();
    private AttributeQueue restrictedAttributes = null;
    private double coveredWeight = 0.0;
    private double positiveWeight = 0.0;

    public Hypothesis() {
    }

    public Hypothesis(Collection<Literal> literals) {
        this();
        for (Literal literal : literals) {
            this.literalMap.put(literal.getAttribute(), literal);
        }
    }

    public void apply(Example example) {
        if (this.applicable(example)) {
            double weight = 1.0;
            if (example.getAttributes().getWeight() != null) {
                weight = example.getWeight();
            }
            this.coveredWeight += weight;
            if (example.getLabel() == (double)example.getAttributes().getLabel().getMapping().getPositiveIndex()) {
                this.positiveWeight += weight;
            }
        }
    }

    public boolean applicable(Example example) {
        for (Literal literal : this.literalMap.values()) {
            if (literal.applicable(example)) continue;
            return false;
        }
        return true;
    }

    private Hypothesis refine(Attribute attribute, double value) {
        Hypothesis hypothesis = this.clone();
        hypothesis.literalMap.put(attribute, new Literal(attribute, value));
        return hypothesis;
    }

    public LinkedList<Hypothesis> refine(Iterable<Attribute> attributes) {
        LinkedList<Hypothesis> hypotheses = new LinkedList<Hypothesis>();
        for (Attribute attribute : attributes) {
            if (this.literalMap.containsKey(attribute)) continue;
            for (String valueString : attribute.getMapping().getValues()) {
                hypotheses.add(this.refine(attribute, attribute.getMapping().mapString(valueString)));
            }
        }
        return hypotheses;
    }

    public LinkedList<Hypothesis> restrictedRefine(Iterable<Attribute> attributes) {
        AttributeQueue restrictedAttributes = new AttributeQueue(attributes);
        LinkedList<Hypothesis> hypotheses = new LinkedList<Hypothesis>();
        Attribute attribute = null;
        while ((attribute = (Attribute)restrictedAttributes.poll()) != null) {
            if (this.literalMap.containsKey(attribute)) continue;
            for (String valueString : attribute.getMapping().getValues()) {
                Hypothesis hypothesis = this.refine(attribute, attribute.getMapping().mapString(valueString));
                hypothesis.restrictedAttributes = new AttributeQueue(restrictedAttributes);
                hypotheses.add(hypothesis);
            }
        }
        return hypotheses;
    }

    public LinkedList<Hypothesis> restrictedRefine() {
        if (this.restrictedAttributes == null) {
            return null;
        }
        return this.restrictedRefine(this.restrictedAttributes);
    }

    public Hypothesis subsume(Hypothesis otherHypothesis) {
        LinkedList<Literal> newLiterals = new LinkedList<Literal>();
        for (Literal otherLiteral : otherHypothesis.literalMap.values()) {
            Literal correspondingLiteral = this.literalMap.get(otherLiteral.getAttribute());
            if (correspondingLiteral == null) continue;
            if (otherLiteral.equals(correspondingLiteral)) {
                newLiterals.add(otherLiteral);
                continue;
            }
            if (!otherLiteral.contradicts(this.literalMap.get(otherLiteral.getAttribute()))) continue;
            return null;
        }
        return new Hypothesis(newLiterals);
    }

    public Hypothesis combine(Hypothesis otherHypothesis) {
        LinkedList<Literal> newLiterals = new LinkedList<Literal>();
        for (Literal otherLiteral : otherHypothesis.literalMap.values()) {
            Literal correspondingLiteral = this.literalMap.get(otherLiteral.getAttribute());
            if (correspondingLiteral == null) {
                newLiterals.add(otherLiteral);
                continue;
            }
            if (!otherLiteral.contradicts(this.literalMap.get(otherLiteral.getAttribute()))) continue;
            return null;
        }
        for (Literal literal : this.literalMap.values()) {
            for (Literal otherLiteral : newLiterals) {
                if (!literal.equals(otherLiteral)) continue;
            }
            newLiterals.add(literal);
        }
        return new Hypothesis(newLiterals);
    }

    private Rule getPredictionRule(Attribute label) {
        double predictionIndex = this.positiveWeight / this.coveredWeight > 0.5 ? (double)label.getMapping().getPositiveIndex() : (double)label.getMapping().getNegativeIndex();
        return new Rule(this, new Literal(label, predictionIndex));
    }

    private Rule getPositiveRule(Attribute label) {
        return new Rule(this, new Literal(label, label.getMapping().getPositiveIndex()));
    }

    private Rule getNegativeRule(Attribute label) {
        return new Rule(this, new Literal(label, label.getMapping().getNegativeIndex()));
    }

    public LinkedList<Rule> generateRules(int ruleGenerationMode, Attribute label) {
        LinkedList<Rule> rules = new LinkedList<Rule>();
        switch (ruleGenerationMode) {
            case 0: {
                rules.add(this.getPositiveRule(label));
                break;
            }
            case 1: {
                rules.add(this.getNegativeRule(label));
                break;
            }
            case 2: {
                rules.add(this.getPredictionRule(label));
                break;
            }
            case 3: {
                rules.add(this.getPositiveRule(label));
                rules.add(this.getNegativeRule(label));
            }
        }
        return rules;
    }

    private Literal getLiteral(Attribute attribute) {
        return this.literalMap.get(attribute);
    }

    private Collection<Literal> getLiterals() {
        return this.literalMap.values();
    }

    public int getNumberOfLiterals() {
        return this.literalMap.size();
    }

    public double getCoveredWeight() {
        return this.coveredWeight;
    }

    public double getPositiveWeight() {
        return this.positiveWeight;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Hypothesis otherHypothesis = (Hypothesis)object;
        for (Literal literal : this.getLiterals()) {
            if (literal.equals(otherHypothesis.getLiteral(literal.getAttribute()))) continue;
            return false;
        }
        return true;
    }

    public Hypothesis clone() {
        Hypothesis newHypothesis = new Hypothesis();
        newHypothesis.literalMap.putAll(this.literalMap);
        return newHypothesis;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (Literal literal : this.literalMap.values()) {
            stringBuffer.append(literal + " , ");
        }
        if (stringBuffer.length() > 3) {
            return stringBuffer.substring(0, stringBuffer.length() - 3);
        }
        return stringBuffer.toString();
    }

    private static class AttributeQueue
    extends LinkedList<Attribute> {
        private static final long serialVersionUID = 8693212785374243323L;

        private AttributeQueue() {
        }

        private AttributeQueue(Iterable<Attribute> attributes) {
            this.addAll(attributes);
        }

        private void addAll(Iterable<Attribute> attributes) {
            for (Attribute attribute : attributes) {
                this.add(attribute);
            }
        }
    }
}

