/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.rules;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorCapability;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.AbstractLearner;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.operator.learner.rules.AccuracyCriterion;
import com.rapidminer.operator.learner.rules.Rule;
import com.rapidminer.operator.learner.rules.RuleModel;
import com.rapidminer.operator.learner.rules.TermDetermination;
import com.rapidminer.operator.learner.tree.SplitCondition;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDouble;
import java.util.List;

public class SimpleRuleLearner
extends AbstractLearner {
    public static final String PARAMETER_PURENESS = "pureness";

    public SimpleRuleLearner(OperatorDescription description) {
        super(description);
    }

    @Override
    public Model learn(ExampleSet exampleSet) throws OperatorException {
        Attribute label = exampleSet.getAttributes().getLabel();
        RuleModel ruleModel = new RuleModel(exampleSet);
        double pureness = this.getParameterAsDouble(PARAMETER_PURENESS);
        TermDetermination termDetermination = new TermDetermination(new AccuracyCriterion(), 0.5);
        ExampleSet trainingSet = (ExampleSet)exampleSet.clone();
        for (String labelName : label.getMapping().getValues()) {
            trainingSet.recalculateAttributeStatistics(label);
            int oldSize = -1;
            while (trainingSet.size() > 0 && trainingSet.size() != oldSize && trainingSet.getStatistics(label, "count", labelName) > 0.0) {
                SplitCondition term;
                Rule rule = new Rule(labelName);
                ExampleSet oldTrainingSet = (ExampleSet)trainingSet.clone();
                int growOldSize = -1;
                ExampleSet growSet = (ExampleSet)trainingSet.clone();
                while (growSet.size() > 0 && growSet.size() != growOldSize && !rule.isPure(growSet, pureness) && growSet.getAttributes().size() > 0 && (term = termDetermination.getBestTerm(growSet, labelName)) != null) {
                    rule.addTerm(term);
                    Attribute splitAttribute = growSet.getAttributes().get(term.getAttributeName());
                    growSet.getAttributes().remove(splitAttribute);
                    growOldSize = growSet.size();
                    growSet = rule.getCovered(growSet);
                }
                if (rule.getTerms().size() <= 0) break;
                growSet = rule.getCovered(trainingSet);
                growSet.recalculateAttributeStatistics(label);
                int[] frequencies = new int[label.getMapping().size()];
                int counter = 0;
                for (String value : label.getMapping().getValues()) {
                    frequencies[counter++] = (int)growSet.getStatistics(label, "count", value);
                }
                rule.setFrequencies(frequencies);
                ruleModel.addRule(rule);
                oldSize = trainingSet.size();
                trainingSet = rule.removeCovered(oldTrainingSet);
                trainingSet.recalculateAttributeStatistics(label);
            }
            this.checkForStop();
        }
        if (trainingSet.size() > 0) {
            trainingSet.recalculateAttributeStatistics(label);
            int index = (int)trainingSet.getStatistics(label, "mode");
            String defaultLabel = label.getMapping().mapIndex(index);
            Rule defaultRule = new Rule(defaultLabel);
            int[] frequencies = new int[label.getMapping().size()];
            int counter = 0;
            for (String value : label.getMapping().getValues()) {
                frequencies[counter++] = (int)trainingSet.getStatistics(label, "count", value);
            }
            defaultRule.setFrequencies(frequencies);
            ruleModel.addRule(defaultRule);
        }
        return ruleModel;
    }

    @Override
    public Class<? extends PredictionModel> getModelClass() {
        return RuleModel.class;
    }

    @Override
    public boolean supportsCapability(OperatorCapability capability) {
        if (capability == OperatorCapability.BINOMINAL_ATTRIBUTES) {
            return true;
        }
        if (capability == OperatorCapability.POLYNOMINAL_ATTRIBUTES) {
            return true;
        }
        if (capability == OperatorCapability.NUMERICAL_ATTRIBUTES) {
            return true;
        }
        if (capability == OperatorCapability.POLYNOMINAL_LABEL) {
            return true;
        }
        if (capability == OperatorCapability.BINOMINAL_LABEL) {
            return true;
        }
        return capability == OperatorCapability.WEIGHTED_EXAMPLES;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeDouble(PARAMETER_PURENESS, "The desired pureness, i.e. the necessary amount of the major class in a covered subset in order become pure.", 0.0, 1.0, 0.9, false));
        return types;
    }
}

