/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.rules;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.learner.rules.AbstractCriterion;

public class InfoGainCriterion
extends AbstractCriterion {
    private static double LOG_FACTOR = 1.0 / Math.log(2.0);

    @Override
    public double[] getBenefit(ExampleSet coveredSet, ExampleSet uncoveredSet, String labelName) {
        double coveredAccuracy = 0.0;
        double coveredCoverage = 0.0;
        Attribute weightAttribute = coveredSet.getAttributes().getWeight();
        Attribute labelAttribute = coveredSet.getAttributes().getLabel();
        int labelIndex = labelAttribute.getMapping().getIndex(labelName);
        for (Example e : coveredSet) {
            double weight = 1.0;
            if (weightAttribute != null) {
                weight = e.getValue(weightAttribute);
            }
            coveredCoverage += weight;
            if (e.getValue(labelAttribute) != (double)labelIndex) continue;
            coveredAccuracy += weight;
        }
        double uncoveredAccuracy = 0.0;
        double uncoveredCoverage = 0.0;
        weightAttribute = uncoveredSet.getAttributes().getWeight();
        labelAttribute = uncoveredSet.getAttributes().getLabel();
        labelIndex = labelAttribute.getMapping().getIndex(labelName);
        for (Example e : uncoveredSet) {
            double weight = 1.0;
            if (weightAttribute != null) {
                weight = e.getValue(weightAttribute);
            }
            uncoveredCoverage += weight;
            if (e.getValue(labelAttribute) != (double)labelIndex) continue;
            uncoveredAccuracy += weight;
        }
        double defaultAccuracy = (coveredAccuracy + uncoveredAccuracy) / (coveredCoverage + uncoveredCoverage);
        double infoGain = coveredAccuracy * (this.log2((coveredAccuracy + 1.0) / (coveredCoverage + 1.0)) - this.log2(defaultAccuracy));
        return new double[]{infoGain, coveredSet.size()};
    }

    @Override
    public double[] getOnlineBenefit(Example example, int labelIndex) {
        double coveredAccuracy = this.labelWeights[labelIndex];
        double coveredWeight = this.weight;
        double uncoveredAccuracy = this.totalLabelWeights[labelIndex] - this.labelWeights[labelIndex];
        double uncoveredWeight = this.totalWeight - this.weight;
        double defaultAccuracy = (coveredAccuracy + uncoveredAccuracy) / (coveredWeight + uncoveredWeight);
        double infoGain = coveredAccuracy * (this.log2((coveredAccuracy + 1.0) / (coveredWeight + 1.0)) - this.log2(defaultAccuracy));
        double reverseInfoGain = uncoveredAccuracy * (this.log2((uncoveredAccuracy + 1.0) / (uncoveredWeight + 1.0)) - this.log2(defaultAccuracy));
        return new double[]{infoGain, coveredWeight, reverseInfoGain, uncoveredWeight};
    }

    private double log2(double value) {
        return Math.log(value) * LOG_FACTOR;
    }
}

