/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.rules;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.SimplePredictionModel;
import com.rapidminer.tools.Tools;
import java.util.Collection;
import java.util.Vector;

public class ConjunctiveRuleModel
extends SimplePredictionModel {
    private static final long serialVersionUID = 9088700646188411002L;
    private final int predictedLabel;
    private final Vector<Literal> myLiterals = new Vector();

    public ConjunctiveRuleModel(ExampleSet exampleSet, int predictedLabel) {
        super(exampleSet);
        this.predictedLabel = predictedLabel;
    }

    public ConjunctiveRuleModel(ExampleSet exampleSet, int predictedLabel, int positives, int negatives) {
        super(exampleSet);
        this.predictedLabel = predictedLabel;
    }

    public ConjunctiveRuleModel(ConjunctiveRuleModel ruleToClone, int predictedLabel) {
        super(ruleToClone.getTrainingHeader());
        this.predictedLabel = predictedLabel;
        this.myLiterals.addAll(ruleToClone.myLiterals);
    }

    public ConjunctiveRuleModel(ConjunctiveRuleModel ruleToExtend, Attribute attribute, double testValue) throws OperatorException {
        super(ruleToExtend.getTrainingHeader());
        if (ruleToExtend.getPositionOfAttributeInRule(attribute) != -1) {
            throw new OperatorException("ConjunctiveRuleModels may not contain the same attribute twice!");
        }
        this.predictedLabel = ruleToExtend.predictedLabel;
        this.myLiterals.addAll(ruleToExtend.myLiterals);
        Literal literalToAdd = new Literal(attribute, testValue);
        this.myLiterals.add(literalToAdd);
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer(super.toString() + Tools.getLineSeparator() + " (" + this.getLabel().getName() + "=" + this.getLabel().getMapping().mapIndex(this.predictedLabel) + ") <-- ");
        for (int i = 0; i < this.getRuleLength(); ++i) {
            Attribute att = this.getAttributeOfLiteral(i);
            String val = att.getMapping().mapIndex((int)this.getTestedValueAtLiteral(i));
            result.append((i > 0 ? ", " : "") + "(" + att.getName() + "=" + val + ")");
        }
        return result.toString();
    }

    private double flipLabel(double nonPredictedLabel) {
        return 1.0 - nonPredictedLabel;
    }

    @Override
    public double predict(Example example) throws OperatorException {
        for (Literal nextLiteral : this.myLiterals) {
            if (nextLiteral.testExample(example)) continue;
            return this.flipLabel(this.predictedLabel);
        }
        return this.predictedLabel;
    }

    public int getRuleLength() {
        return this.myLiterals.size();
    }

    public int getConclusion() {
        return this.predictedLabel;
    }

    public Attribute getAttributeOfLiteral(int literalNumber) {
        return this.myLiterals.get(literalNumber).getAttribute();
    }

    public double getTestedValueAtLiteral(int literalNumber) {
        return this.myLiterals.get(literalNumber).getValue();
    }

    public int getPositionOfAttributeInRule(Attribute attribute) {
        int index;
        int ruleLength = this.getRuleLength();
        for (index = 0; index < ruleLength && !((Object)attribute).equals(this.getAttributeOfLiteral(index)); ++index) {
        }
        return index == ruleLength ? -1 : index;
    }

    public boolean isRefinementOf(ConjunctiveRuleModel model) {
        if (this == model) {
            return true;
        }
        int numLiterals = model.getRuleLength();
        if (this.getRuleLength() < numLiterals || this.getConclusion() != model.getConclusion()) {
            return false;
        }
        for (int i = 0; i < numLiterals; ++i) {
            Attribute attribute = model.getAttributeOfLiteral(i);
            int pos = this.getPositionOfAttributeInRule(attribute);
            if (pos == -1) {
                return false;
            }
            if (model.getTestedValueAtLiteral(i) == this.getTestedValueAtLiteral(pos)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof ConjunctiveRuleModel)) {
            return false;
        }
        ConjunctiveRuleModel rule = (ConjunctiveRuleModel)object;
        if (this.getRuleLength() != rule.getRuleLength() || this.getConclusion() != rule.getConclusion()) {
            return false;
        }
        for (int i = 0; i < this.getRuleLength(); ++i) {
            Attribute att = this.getAttributeOfLiteral(i);
            int pos = rule.getPositionOfAttributeInRule(att);
            if (pos != -1 && this.getTestedValueAtLiteral(i) == rule.getTestedValueAtLiteral(pos)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Integer.valueOf(this.getRuleLength()).hashCode() ^ Integer.valueOf(this.getConclusion()).hashCode() ^ this.myLiterals.hashCode();
    }

    protected int getFirstUnusedAttribute(ExampleSet exampleSet, Attribute[] allAttributes) {
        int numAttributes;
        int firstUnusedAttribute = numAttributes = allAttributes.length;
        int i = numAttributes - 1;
        while (i >= 0) {
            Attribute exampleSetAttribute = allAttributes[i];
            if (this.getPositionOfAttributeInRule(exampleSetAttribute) != -1) {
                return firstUnusedAttribute;
            }
            firstUnusedAttribute = i--;
        }
        return firstUnusedAttribute;
    }

    public Collection<ConjunctiveRuleModel> getAllRefinedRules(ExampleSet exampleSet) throws OperatorException {
        Attribute[] allAttributes = exampleSet.getAttributes().createRegularAttributeArray();
        int numAttributes = allAttributes.length;
        int firstUnused = this.getFirstUnusedAttribute(exampleSet, allAttributes);
        Vector<ConjunctiveRuleModel> theRefinements = new Vector<ConjunctiveRuleModel>();
        for (int i = firstUnused; i < numAttributes; ++i) {
            Attribute nextAttribute = allAttributes[i];
            for (String valueS : nextAttribute.getMapping().getValues()) {
                int value = nextAttribute.getMapping().getIndex(valueS);
                ConjunctiveRuleModel refinedRule = new ConjunctiveRuleModel(this, nextAttribute, value);
                theRefinements.add(refinedRule);
            }
        }
        return theRefinements;
    }

    private static class Literal {
        private final Attribute myAttribute;
        private final double myValue;

        public Literal(Attribute attribute, double testedValue) {
            this.myAttribute = attribute;
            this.myValue = testedValue;
        }

        public Attribute getAttribute() {
            return this.myAttribute;
        }

        public double getValue() {
            return this.myValue;
        }

        public boolean testExample(Example example) {
            return example.getValue(this.getAttribute()) == this.getValue();
        }
    }
}

