/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.rules;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorCapability;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.AbstractLearner;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.operator.learner.rules.ConjunctiveRuleModel;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class BestRuleInduction
extends AbstractLearner {
    private static final String PARAMETER_MAX_DEPTH = "max_depth";
    private static final String PARAMETER_UTILITY_FUNCTION = "utility_function";
    private static final String PARAMETER_MAX_CACHE = "max_cache";
    private static final String PARAMETER_RELATIVE_TO_PREDICTIONS = "relative_to_predictions";
    private static final String WRACC = "weighted relative accuracy";
    private static final String BINOMIAL = "binomial test function";
    private static final String[] UTILITY_FUNCTION_LIST = new String[]{"weighted relative accuracy", "binomial test function"};
    private double globalP;
    private double globalN;
    protected ConjunctiveRuleModel bestRule;
    private double bestScore;
    private final Vector<RuleWithScoreUpperBound> openNodes = new Vector();
    private final Vector<ConjunctiveRuleModel> prunedNodes = new Vector();

    public BestRuleInduction(OperatorDescription description) {
        super(description);
    }

    @Override
    public boolean supportsCapability(OperatorCapability lc) {
        if (lc == OperatorCapability.POLYNOMINAL_ATTRIBUTES) {
            return true;
        }
        if (lc == OperatorCapability.BINOMINAL_ATTRIBUTES) {
            return true;
        }
        if (lc == OperatorCapability.BINOMINAL_LABEL) {
            return true;
        }
        return lc == OperatorCapability.WEIGHTED_EXAMPLES;
    }

    protected void initHighscore() {
        this.bestRule = null;
        this.bestScore = Double.NEGATIVE_INFINITY;
    }

    protected boolean communicateToHighscore(ConjunctiveRuleModel rule, double[] counts) throws UndefinedParameterError {
        double optimisticScore = this.getOptimisticScore(counts);
        if (optimisticScore <= this.getPruningScore()) {
            return true;
        }
        double posScore = this.getScore(counts, true);
        double negScore = this.getScore(counts, false);
        if (posScore > this.bestScore) {
            this.bestRule = rule;
            this.bestScore = posScore;
        }
        if (negScore > this.bestScore) {
            ConjunctiveRuleModel negRule;
            this.bestRule = negRule = new ConjunctiveRuleModel(rule, rule.getLabel().getMapping().getNegativeIndex());
            this.bestScore = negScore;
        }
        return false;
    }

    protected ConjunctiveRuleModel getBestRule() {
        return this.bestRule;
    }

    protected double getPruningScore() {
        return this.bestScore;
    }

    @Override
    public Model learn(ExampleSet exampleSet) throws OperatorException {
        this.initHighscore();
        int positiveLabel = exampleSet.getAttributes().getLabel().getMapping().getPositiveIndex();
        ConjunctiveRuleModel defaultRule = new ConjunctiveRuleModel(exampleSet, positiveLabel);
        double[] globalCounts = this.getCounts(defaultRule, exampleSet);
        this.globalP = globalCounts[0];
        this.globalN = globalCounts[1];
        this.communicateToHighscore(defaultRule, globalCounts);
        double optimisticScore = this.getOptimisticScore(globalCounts);
        this.openNodes.clear();
        this.prunedNodes.clear();
        this.addRulesToOpenNodes(defaultRule.getAllRefinedRules(exampleSet), optimisticScore);
        for (int length = 1; !this.openNodes.isEmpty() && length <= this.getParameterAsInt(PARAMETER_MAX_DEPTH); ++length) {
            int ignored = 0;
            this.log("Evaluating " + this.openNodes.size() + " rules of length " + length);
            if (this.openNodes.size() > this.getParameterAsInt(PARAMETER_MAX_CACHE)) {
                this.log("Ignoring all but the " + this.getParameterAsInt(PARAMETER_MAX_CACHE) + " rules with highest support.");
            }
            Object[] ruleArray = new RuleWithScoreUpperBound[this.openNodes.size()];
            this.openNodes.toArray(ruleArray);
            Arrays.sort(ruleArray);
            int stopAtIndex = Math.max(0, ruleArray.length - this.getParameterAsInt(PARAMETER_MAX_CACHE));
            this.openNodes.clear();
            for (int i = ruleArray.length - 1; i >= stopAtIndex; --i) {
                Object rulePlusScore = ruleArray[i];
                ConjunctiveRuleModel rule = ((RuleWithScoreUpperBound)rulePlusScore).getRule();
                if (this.isRefinementOfPrunedRule(rule)) {
                    ++ignored;
                } else if (((RuleWithScoreUpperBound)rulePlusScore).getScoreBound() <= this.getPruningScore()) {
                    ++ignored;
                    this.prunedNodes.add(((RuleWithScoreUpperBound)rulePlusScore).getRule());
                } else {
                    this.expandNode(rule, exampleSet);
                }
                this.checkForStop();
            }
            this.log("Could ignore " + ignored + " rules as refinements of pruned rules or by optimistic estimates.");
            this.log("Number of pruned rules in cache: " + this.prunedNodes.size());
            this.log("Best rule is " + this.getBestRule().toString());
            this.log("Score is " + this.getPruningScore());
        }
        this.openNodes.clear();
        this.prunedNodes.clear();
        return this.getBestRule();
    }

    private void addRulesToOpenNodes(Collection rules, double scoreUpperBound) {
        if (scoreUpperBound <= this.getPruningScore()) {
            return;
        }
        Iterator it = rules.iterator();
        while (it.hasNext()) {
            this.openNodes.add(new RuleWithScoreUpperBound((ConjunctiveRuleModel)it.next(), scoreUpperBound));
        }
    }

    private void expandNode(ConjunctiveRuleModel rule, ExampleSet exampleSet) throws OperatorException {
        double[] counts = this.getCounts(rule, exampleSet);
        boolean pruning = this.communicateToHighscore(rule, counts);
        if (pruning) {
            this.prunedNodes.add(rule);
        } else if (rule.getRuleLength() < this.getParameterAsInt(PARAMETER_MAX_DEPTH)) {
            this.addRulesToOpenNodes(rule.getAllRefinedRules(exampleSet), this.getOptimisticScore(counts));
        }
    }

    public boolean isRefinementOfPrunedRule(ConjunctiveRuleModel rule) {
        for (ConjunctiveRuleModel prunedRule : this.prunedNodes) {
            if (!rule.isRefinementOf(prunedRule)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected double getScore(double[] counts, boolean predictPositives) throws UndefinedParameterError {
        double pnEst;
        double p = counts[0];
        double n = counts[1];
        double cov = (p + n) / (this.globalP + this.globalN);
        double pnRel = predictPositives ? p : n;
        String function = UTILITY_FUNCTION_LIST[this.getParameterAsInt(PARAMETER_UTILITY_FUNCTION)];
        UndefinedParameterError upe = new UndefinedParameterError(PARAMETER_UTILITY_FUNCTION, this);
        if (!this.getParameterAsBoolean(PARAMETER_RELATIVE_TO_PREDICTIONS) || counts.length != 4) {
            double pnAbs;
            double d = pnAbs = predictPositives ? this.globalP : this.globalN;
            if (function.equals(WRACC)) {
                return cov * (pnRel / (p + n) - pnAbs / (this.globalP + this.globalN));
            }
            if (!function.equals(BINOMIAL)) throw upe;
            return Math.sqrt(cov) * (pnRel / (p + n) - pnAbs / (this.globalP + this.globalN));
        }
        double estP = counts[2];
        double estN = counts[3];
        double d = pnEst = predictPositives ? estP : estN;
        if (function.equals(WRACC)) {
            return cov * (pnRel / (p + n) - pnEst / (estP + estN));
        }
        if (!function.equals(BINOMIAL)) throw upe;
        return Math.sqrt(cov) * (pnRel / (p + n) - pnEst / (estP + estN));
    }

    protected double getOptimisticScore(double[] counts) throws UndefinedParameterError {
        double p = counts[0];
        double n = counts[1];
        if (!this.getParameterAsBoolean(PARAMETER_RELATIVE_TO_PREDICTIONS) || counts.length != 4) {
            return Math.max(this.getScore(new double[]{p, 0.0}, true), this.getScore(new double[]{0.0, n}, false));
        }
        double estP = counts[2];
        double estN = counts[3];
        return Math.max(this.getScore(new double[]{p, 0.0, 0.0, estN}, true), this.getScore(new double[]{0.0, n, 0.0, estP}, false));
    }

    protected double[] getCounts(ConjunctiveRuleModel rule, ExampleSet exampleSet) throws OperatorException {
        double[] dArray;
        Attribute weightAttr = exampleSet.getAttributes().getWeight();
        Attribute predictedLabel = exampleSet.getAttributes().getPredictedLabel();
        boolean relToPred = predictedLabel != null && this.getParameterAsBoolean(PARAMETER_RELATIVE_TO_PREDICTIONS);
        int coveredPart = rule.getConclusion();
        int posIndex = exampleSet.getAttributes().getLabel().getMapping().getPositiveIndex();
        int negIndex = exampleSet.getAttributes().getLabel().getMapping().getNegativeIndex();
        String posS = null;
        String negS = null;
        if (relToPred) {
            posS = predictedLabel.getMapping().mapIndex(posIndex);
            negS = predictedLabel.getMapping().mapIndex(negIndex);
        }
        double p = 0.0;
        double n = 0.0;
        double estP = 0.0;
        double estN = 0.0;
        for (Example example : exampleSet) {
            double weight;
            double d = weight = weightAttr == null ? 1.0 : example.getValue(weightAttr);
            if (rule.predict(example) != (double)coveredPart) continue;
            if (example.getValue(example.getAttributes().getLabel()) == (double)posIndex) {
                p += weight;
            } else {
                n += weight;
            }
            if (!relToPred) continue;
            double sum = example.getConfidence(posS) + example.getConfidence(negS);
            estP += weight * example.getConfidence(posS) / sum;
            estN += weight * example.getConfidence(negS) / sum;
        }
        if (relToPred) {
            double[] dArray2 = new double[4];
            dArray2[0] = p;
            dArray2[1] = n;
            dArray2[2] = estP;
            dArray = dArray2;
            dArray2[3] = estN;
        } else {
            double[] dArray3 = new double[2];
            dArray3[0] = p;
            dArray = dArray3;
            dArray3[1] = n;
        }
        return dArray;
    }

    @Override
    public Class<? extends PredictionModel> getModelClass() {
        return ConjunctiveRuleModel.class;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeInt(PARAMETER_MAX_DEPTH, "An upper bound for the number of literals.", 1, Integer.MAX_VALUE, 2));
        types.add(new ParameterTypeCategory(PARAMETER_UTILITY_FUNCTION, "The function to be optimized by the rule.", UTILITY_FUNCTION_LIST, 0));
        types.add(new ParameterTypeInt(PARAMETER_MAX_CACHE, "Bounds the number of rules considered per depth to avoid high memory consumption, but leads to incomplete search.", 1, Integer.MAX_VALUE, 10000));
        types.add(new ParameterTypeBoolean(PARAMETER_RELATIVE_TO_PREDICTIONS, "Searches for rules with a maximum difference to the predited label.", false));
        return types;
    }

    public static class RuleWithScoreUpperBound
    implements Comparable {
        private final ConjunctiveRuleModel rule;
        private final double scoreUpperBound;

        public RuleWithScoreUpperBound(ConjunctiveRuleModel rule, double scoreUpperBound) {
            this.rule = rule;
            this.scoreUpperBound = scoreUpperBound;
        }

        public ConjunctiveRuleModel getRule() {
            return this.rule;
        }

        public double getScoreBound() {
            return this.scoreUpperBound;
        }

        public int compareTo(Object obj) {
            if (obj instanceof RuleWithScoreUpperBound) {
                double otherScore = ((RuleWithScoreUpperBound)obj).getScoreBound();
                if (this.getScoreBound() < otherScore) {
                    return -1;
                }
                if (this.getScoreBound() > otherScore) {
                    return 1;
                }
                return 0;
            }
            return this.getClass().getName().compareTo(obj.getClass().getName());
        }

        public boolean equals(Object o) {
            if (!(o instanceof RuleWithScoreUpperBound)) {
                return false;
            }
            return this.rule.equals(((RuleWithScoreUpperBound)o).rule);
        }

        public int hashCode() {
            return this.rule.hashCode();
        }
    }
}

