/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.rules;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.learner.rules.Criterion;

public abstract class AbstractCriterion
implements Criterion {
    protected double[] labelWeights;
    protected double weight;
    protected double[] totalLabelWeights;
    protected double totalWeight;
    protected Attribute labelAttribute;
    protected Attribute weightAttribute;

    @Override
    public void update(Example example) {
        int labelIndex = (int)example.getValue(this.labelAttribute);
        if (this.weightAttribute != null) {
            double currentWeight = example.getValue(this.weightAttribute);
            int n = labelIndex;
            this.labelWeights[n] = this.labelWeights[n] + currentWeight;
            this.weight += currentWeight;
        } else {
            int n = labelIndex;
            this.labelWeights[n] = this.labelWeights[n] + 1.0;
            this.weight += 1.0;
        }
    }

    @Override
    public double[] getOnlineBenefit(Example example) {
        double maxWeight = Double.NEGATIVE_INFINITY;
        int mostFrequentLabelIndex = 0;
        for (int i = 0; i < this.labelWeights.length; ++i) {
            if (!(this.labelWeights[i] > maxWeight)) continue;
            mostFrequentLabelIndex = i;
            maxWeight = this.labelWeights[i];
        }
        return this.getOnlineBenefit(example, mostFrequentLabelIndex);
    }

    @Override
    public void reinitOnlineCounting(ExampleSet exampleSet) {
        this.labelAttribute = exampleSet.getAttributes().getLabel();
        this.weightAttribute = exampleSet.getAttributes().getWeight();
        this.totalLabelWeights = new double[this.labelAttribute.getMapping().size()];
        this.totalWeight = 0.0;
        if (exampleSet.getAttributes().getWeight() != null) {
            for (Example example : exampleSet) {
                double weight = example.getWeight();
                int n = (int)example.getValue(this.labelAttribute);
                this.totalLabelWeights[n] = this.totalLabelWeights[n] + weight;
            }
        } else {
            for (Example example : exampleSet) {
                int n = (int)example.getValue(this.labelAttribute);
                this.totalLabelWeights[n] = this.totalLabelWeights[n] + 1.0;
            }
        }
        for (int i = 0; i < this.totalLabelWeights.length; ++i) {
            this.totalWeight += this.totalLabelWeights[i];
        }
        this.labelWeights = new double[this.labelAttribute.getMapping().size()];
        this.weight = 0.0;
    }
}

