/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.meta;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCapability;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.operator.learner.meta.AbstractMetaLearner;
import com.rapidminer.operator.learner.rules.Rule;
import com.rapidminer.operator.learner.rules.RuleModel;
import com.rapidminer.operator.learner.tree.Edge;
import com.rapidminer.operator.learner.tree.SplitCondition;
import com.rapidminer.operator.learner.tree.Tree;
import com.rapidminer.operator.learner.tree.TreeModel;
import com.rapidminer.operator.ports.metadata.PredictionModelMetaData;
import com.rapidminer.operator.ports.metadata.SimplePrecondition;
import java.util.Iterator;

public class Tree2RuleConverter
extends AbstractMetaLearner {
    public Tree2RuleConverter(OperatorDescription description) {
        super(description);
        this.innerModelSink.addPrecondition(new SimplePrecondition(this.innerModelSink, new PredictionModelMetaData((Class<? extends PredictionModel>)TreeModel.class)));
    }

    @Override
    public Model learn(ExampleSet exampleSet) throws OperatorException {
        Model innerModel = this.applyInnerLearner(exampleSet);
        TreeModel treeModel = null;
        if (!(innerModel instanceof TreeModel)) {
            throw new UserError((Operator)this, 127, "the inner learner must produce a tree model.");
        }
        treeModel = (TreeModel)innerModel;
        Tree tree = treeModel.getRoot();
        RuleModel ruleModel = new RuleModel(exampleSet);
        this.addRules(ruleModel, new Rule(), tree);
        return ruleModel;
    }

    private void addRules(RuleModel ruleModel, Rule currentRule, Tree tree) {
        if (tree.isLeaf()) {
            currentRule.setLabel(tree.getLabel());
            int[] frequencies = new int[ruleModel.getLabel().getMapping().size()];
            int index = 0;
            for (String labelValue : ruleModel.getLabel().getMapping().getValues()) {
                frequencies[index++] = tree.getCount(labelValue);
            }
            currentRule.setFrequencies(frequencies);
            ruleModel.addRule(currentRule);
        } else {
            Iterator<Edge> e = tree.childIterator();
            while (e.hasNext()) {
                Edge edge = e.next();
                SplitCondition condition = edge.getCondition();
                Tree child = edge.getChild();
                Rule clonedRule = (Rule)currentRule.clone();
                clonedRule.addTerm(condition);
                this.addRules(ruleModel, clonedRule, child);
            }
        }
    }

    @Override
    public boolean supportsCapability(OperatorCapability capability) {
        switch (capability) {
            case BINOMINAL_ATTRIBUTES: 
            case POLYNOMINAL_ATTRIBUTES: 
            case NUMERICAL_ATTRIBUTES: 
            case POLYNOMINAL_LABEL: 
            case BINOMINAL_LABEL: 
            case WEIGHTED_EXAMPLES: 
            case MISSING_VALUES: {
                return true;
            }
        }
        return false;
    }
}

