/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.meta;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.operator.learner.meta.DelegationModel;
import com.rapidminer.tools.Tools;
import java.util.Iterator;

public class TransformedRegressionModel
extends PredictionModel
implements DelegationModel {
    private static final long serialVersionUID = -1273082758742436998L;
    public static final String[] METHODS = new String[]{"log", "logistic link", "exp", "rank", "none"};
    public static final int LOG = 0;
    public static final int LOG_LINK = 1;
    public static final int EXP = 2;
    public static final int RANK = 3;
    public static final int NONE = 4;
    private int method;
    private double[] rank;
    private double mean;
    private double stddev;
    private Model model;
    private boolean interpolate;
    private boolean zscale;

    public TransformedRegressionModel(ExampleSet exampleSet, int method, double[] rank, Model model, boolean zscale, double mean, double stddev, boolean interpolate) {
        super(exampleSet);
        this.method = method;
        this.rank = rank;
        this.model = model;
        this.zscale = zscale;
        this.mean = mean;
        this.stddev = stddev;
        this.interpolate = interpolate;
    }

    @Override
    public ExampleSet performPrediction(ExampleSet exampleSet, Attribute predictedLabelAttribute) throws OperatorException {
        ExampleSet eSet = (ExampleSet)exampleSet.clone();
        eSet = this.model.apply(eSet);
        Iterator reader = eSet.iterator();
        Iterator originalReader = exampleSet.iterator();
        switch (this.method) {
            case 0: {
                while (originalReader.hasNext()) {
                    double functionValue = ((Example)reader.next()).getPredictedLabel();
                    if (this.zscale) {
                        functionValue = functionValue * this.stddev + this.mean;
                    }
                    Example example = (Example)originalReader.next();
                    example.setPredictedLabel(Math.exp(functionValue) - this.rank[0]);
                }
                break;
            }
            case 1: {
                while (originalReader.hasNext()) {
                    double functionValue = ((Example)reader.next()).getPredictedLabel();
                    if (this.zscale) {
                        functionValue = functionValue * this.stddev + this.mean;
                    }
                    Example example = (Example)originalReader.next();
                    double powered = Math.exp(functionValue);
                    example.setPredictedLabel(powered / (1.0 + powered));
                }
                break;
            }
            case 2: {
                while (originalReader.hasNext()) {
                    double functionValue = ((Example)reader.next()).getPredictedLabel();
                    if (this.zscale) {
                        functionValue = functionValue * this.stddev + this.mean;
                    }
                    Example example = (Example)originalReader.next();
                    example.setPredictedLabel(Math.log(functionValue));
                }
                break;
            }
            case 3: {
                while (originalReader.hasNext()) {
                    double predictedRank = ((Example)reader.next()).getPredictedLabel();
                    if (this.zscale) {
                        predictedRank = predictedRank * this.stddev + this.mean;
                    }
                    Example example = (Example)originalReader.next();
                    if (this.interpolate) {
                        int lower = (int)Math.round(Math.floor(predictedRank));
                        int upper = (int)Math.round(Math.ceil(predictedRank));
                        if (lower < 0) {
                            lower = 0;
                        }
                        if (lower >= this.rank.length) {
                            lower = this.rank.length - 1;
                        }
                        if (upper < 0) {
                            upper = 0;
                        }
                        if (upper >= this.rank.length) {
                            upper = this.rank.length - 1;
                        }
                        predictedRank = upper != lower ? ((double)upper - predictedRank) * this.rank[lower] + (predictedRank - (double)lower) * this.rank[upper] : this.rank[lower];
                    } else {
                        int thisRank = (int)Math.round(predictedRank);
                        if (thisRank < 0) {
                            thisRank = 0;
                        }
                        if (thisRank >= this.rank.length) {
                            thisRank = this.rank.length - 1;
                        }
                        predictedRank = this.rank[thisRank];
                    }
                    example.setPredictedLabel(predictedRank);
                }
                break;
            }
            case 4: {
                if (!this.zscale) break;
                while (originalReader.hasNext()) {
                    double functionValue = ((Example)reader.next()).getPredictedLabel() * this.stddev + this.mean;
                    Example example = (Example)originalReader.next();
                    example.setPredictedLabel(functionValue);
                }
                break;
            }
        }
        return exampleSet;
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer(super.toString() + Tools.getLineSeparator());
        result.append("Method: " + METHODS[this.method] + Tools.getLineSeparator());
        result.append(this.model.toString());
        return result.toString();
    }

    @Override
    public Model getBaseModel() {
        return this.model;
    }

    @Override
    public String getShortInfo() {
        return "Method used: " + METHODS[this.method] + Tools.getLineSeparator();
    }
}

