/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.meta;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorCapability;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.learner.meta.AbstractMetaLearner;
import com.rapidminer.operator.learner.meta.TransformedRegressionModel;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.PortPairExtender;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MDReal;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.ports.metadata.SimpleMetaDataError;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class TransformedRegression
extends AbstractMetaLearner {
    public static final String PARAMETER_TRANSFORMATION_METHOD = "transformation_method";
    public static final String PARAMETER_Z_SCALE = "z_scale";
    public static final String PARAMETER_INTERPOLATE_RANK = "interpolate_rank";
    private final PortPairExtender through = new PortPairExtender("through", this.getSubprocess(0).getInnerSinks(), this.getOutputPorts());

    public TransformedRegression(OperatorDescription description) {
        super(description);
        this.through.start();
        this.getTransformer().addRule(this.through.makePassThroughRule());
    }

    @Override
    protected MetaData modifyExampleSetMetaData(ExampleSetMetaData unmodifiedMetaData) {
        switch (unmodifiedMetaData.hasSpecial("label")) {
            case NO: {
                this.getTrainingSetInputPort().addError(new SimpleMetaDataError(ProcessSetupError.Severity.ERROR, (Port)this.getTrainingSetInputPort(), "special_missing", "label"));
                return unmodifiedMetaData;
            }
            case UNKNOWN: {
                this.getTrainingSetInputPort().addError(new SimpleMetaDataError(ProcessSetupError.Severity.WARNING, (Port)this.getTrainingSetInputPort(), "special_unknown", "label"));
                return unmodifiedMetaData;
            }
            case YES: {
                AttributeMetaData labelMD = unmodifiedMetaData.getLabelMetaData();
                unmodifiedMetaData.removeAttribute(labelMD);
                AttributeMetaData transformedMD = labelMD.copy();
                transformedMD.setName("transformation(" + labelMD.getName() + ")");
                transformedMD.setValueSetRelation(SetRelation.UNKNOWN);
                transformedMD.setMean(new MDReal());
                unmodifiedMetaData.addAttribute(transformedMD);
                return unmodifiedMetaData;
            }
        }
        return unmodifiedMetaData;
    }

    @Override
    public Model learn(ExampleSet inputSet) throws OperatorException {
        int method = this.getParameterAsInt(PARAMETER_TRANSFORMATION_METHOD);
        double[] rank = null;
        double mean = 0.0;
        double stddev = 1.0;
        Attribute label = inputSet.getAttributes().getLabel();
        inputSet.recalculateAttributeStatistics(label);
        ExampleSet eSet = (ExampleSet)inputSet.clone();
        Attribute tempLabel = AttributeFactory.createAttribute("transformation(" + label.getName() + ")", 4);
        eSet.getExampleTable().addAttribute(tempLabel);
        Iterator r = eSet.iterator();
        switch (method) {
            case 0: {
                Example e;
                double offset = 1.0 - inputSet.getStatistics(label, "minimum");
                rank = new double[]{offset};
                while (r.hasNext()) {
                    e = (Example)r.next();
                    e.setValue(tempLabel, Math.log(offset + e.getValue(label)));
                }
                break;
            }
            case 1: {
                Example e;
                while (r.hasNext()) {
                    e = (Example)r.next();
                    double value = e.getValue(label);
                    if (value >= 1.0) {
                        value = 0.99999999999;
                    }
                    if (value <= 0.0) {
                        value = 1.0E-11;
                    }
                    e.setValue(tempLabel, Math.log(value / (1.0 - value)));
                }
                break;
            }
            case 2: {
                Example e;
                while (r.hasNext()) {
                    e = (Example)r.next();
                    e.setValue(tempLabel, Math.exp(e.getValue(label)));
                }
                break;
            }
            case 3: {
                int j;
                double[] dummy = new double[eSet.size()];
                int i = 0;
                while (r.hasNext()) {
                    Example e = (Example)r.next();
                    dummy[i] = e.getValue(label);
                    ++i;
                }
                Arrays.sort(dummy);
                i = 0;
                for (j = 0; j < dummy.length; ++j) {
                    if (dummy[i] == dummy[j]) continue;
                    dummy[++i] = dummy[j];
                }
                rank = new double[i + 1];
                for (j = 0; j < i + 1; ++j) {
                    rank[j] = dummy[j];
                }
                for (Example e : eSet) {
                    e.setValue(tempLabel, Arrays.binarySearch(rank, e.getValue(label)));
                }
                break;
            }
            case 4: {
                while (r.hasNext()) {
                    Example e = (Example)r.next();
                    e.setValue(tempLabel, e.getValue(label));
                }
                break;
            }
        }
        if (this.getParameterAsBoolean(PARAMETER_Z_SCALE)) {
            eSet.recalculateAttributeStatistics(tempLabel);
            mean = eSet.getStatistics(tempLabel, "average");
            stddev = eSet.getStatistics(tempLabel, "variance");
            if (stddev <= 0.0) {
                stddev = 1.0;
            }
            for (Example e : eSet) {
                e.setValue(tempLabel, (e.getValue(tempLabel) - mean) / stddev);
            }
        }
        eSet.getAttributes().remove(label);
        eSet.getAttributes().addRegular(tempLabel);
        eSet.getAttributes().setLabel(tempLabel);
        Model model = this.applyInnerLearner(eSet);
        TransformedRegressionModel resultModel = new TransformedRegressionModel(inputSet, method, rank, model, this.getParameterAsBoolean(PARAMETER_Z_SCALE), mean, stddev, this.getParameterAsBoolean(PARAMETER_INTERPOLATE_RANK));
        this.through.passDataThrough();
        return resultModel;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeCategory(PARAMETER_TRANSFORMATION_METHOD, "Type of transformation to use on the labels (log, exp, transform to mean 0 and variance 1, rank, or none).", TransformedRegressionModel.METHODS, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_Z_SCALE, "If checked the values will be normalized to mean 0 and standard deviation 1.", false);
        type.setExpert(true);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_INTERPOLATE_RANK, "If checked and predicted rank is not an integer, it will be interpolated.", true);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_TRANSFORMATION_METHOD, TransformedRegressionModel.METHODS, false, 3));
        type.setExpert(true);
        types.add(type);
        return types;
    }

    @Override
    public boolean supportsCapability(OperatorCapability capability) {
        switch (capability) {
            case POLYNOMINAL_LABEL: 
            case BINOMINAL_LABEL: 
            case NO_LABEL: 
            case UPDATABLE: 
            case FORMULA_PROVIDER: {
                return false;
            }
        }
        return true;
    }
}

