/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.meta;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.operator.learner.meta.DelegationModel;
import com.rapidminer.tools.Tools;
import java.util.LinkedList;

public class ThresholdModel
extends PredictionModel
implements DelegationModel {
    private static final long serialVersionUID = -4224958349396815500L;
    private double[] thresholds;
    private Model innerModel;

    public ThresholdModel(ExampleSet exampleSet, Model innerModel, double[] thresholds) {
        super(exampleSet);
        this.innerModel = innerModel;
        this.thresholds = thresholds;
    }

    @Override
    public ExampleSet performPrediction(ExampleSet exampleSet, Attribute predictedLabel) throws OperatorException {
        exampleSet = this.innerModel.apply(exampleSet);
        for (Example example : exampleSet) {
            int predictionIndex = (int)example.getPredictedLabel();
            String className = this.getLabel().getMapping().mapIndex(predictionIndex);
            double confidence = example.getConfidence(className);
            if (!(confidence < this.thresholds[predictionIndex])) continue;
            example.setPredictedLabel(Double.NaN);
        }
        return exampleSet;
    }

    @Override
    public String toString() {
        LinkedList<String> thresholdList = new LinkedList<String>();
        for (double d : this.thresholds) {
            thresholdList.add(Tools.formatIntegerIfPossible(d));
        }
        return "Thresholds: " + thresholdList + Tools.getLineSeparator() + this.innerModel.toString();
    }

    @Override
    public Model getBaseModel() {
        return this.innerModel;
    }

    @Override
    public String getShortInfo() {
        LinkedList<String> thresholdList = new LinkedList<String>();
        for (double d : this.thresholds) {
            thresholdList.add(Tools.formatIntegerIfPossible(d));
        }
        return "Thresholds: " + thresholdList;
    }
}

