/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.meta;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.operator.learner.meta.MetaModel;
import com.rapidminer.tools.Tools;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class StackingModel
extends PredictionModel
implements MetaModel {
    private static final long serialVersionUID = -3978054415189320147L;
    private String modelName;
    private List<Model> baseModels;
    private Model stackingModel;
    private boolean useAllAttributes;

    public StackingModel(ExampleSet exampleSet, String modelName, List<Model> baseModels, Model stackingModel, boolean useAllAttributes) {
        super(exampleSet);
        this.modelName = modelName;
        this.baseModels = baseModels;
        this.stackingModel = stackingModel;
        this.useAllAttributes = useAllAttributes;
    }

    @Override
    public String getName() {
        return this.modelName;
    }

    @Override
    public ExampleSet performPrediction(ExampleSet exampleSet, Attribute predictedLabel) throws OperatorException {
        PredictionModel.removePredictedLabel(exampleSet, true, true);
        ExampleSet stackingExampleSet = (ExampleSet)exampleSet.clone();
        if (!this.useAllAttributes) {
            stackingExampleSet.getAttributes().clearRegular();
        }
        LinkedList<Attribute> tempPredictions = new LinkedList<Attribute>();
        int i = 0;
        for (Model baseModel : this.baseModels) {
            exampleSet = baseModel.apply(exampleSet);
            Attribute basePrediction = exampleSet.getAttributes().getPredictedLabel();
            basePrediction.setName("base_prediction" + i);
            PredictionModel.removePredictedLabel(exampleSet, false, true);
            stackingExampleSet.getAttributes().addRegular(basePrediction);
            tempPredictions.add(basePrediction);
            ++i;
        }
        stackingExampleSet = this.stackingModel.apply(stackingExampleSet);
        PredictionModel.copyPredictedLabel(stackingExampleSet, exampleSet);
        for (Attribute tempPrediction : tempPredictions) {
            stackingExampleSet.getAttributes().remove(tempPrediction);
            stackingExampleSet.getExampleTable().removeAttribute(tempPrediction);
        }
        return exampleSet;
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer(super.toString() + Tools.getLineSeparators(2));
        result.append(this.modelName + ":");
        result.append(Tools.getLineSeparator() + this.stackingModel.toString() + Tools.getLineSeparators(2));
        result.append("Base Models:");
        for (Model baseModel : this.baseModels) {
            result.append(Tools.getLineSeparator() + baseModel.toString());
        }
        return result.toString();
    }

    @Override
    public List<String> getModelNames() {
        LinkedList<String> names = new LinkedList<String>();
        for (int i = 0; i < this.baseModels.size(); ++i) {
            names.add("Model " + (i + 1));
        }
        names.add("Stacking Model");
        return names;
    }

    @Override
    public List<? extends Model> getModels() {
        ArrayList<Model> models = new ArrayList<Model>(this.baseModels);
        models.add(this.stackingModel);
        return models;
    }
}

