/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.meta;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.ExecutionUnit;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.operator.learner.meta.AbstractStacking;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.SubprocessTransformRule;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import java.util.List;

public class Stacking
extends AbstractStacking {
    private final OutputPort stackingExamplesInnerSource = (OutputPort)this.getSubprocess(1).getInnerSources().createPort("stacking examples");
    private final InputPort stackingModelInnerSink = this.getSubprocess(1).getInnerSinks().createPort("stacking model", PredictionModel.class);
    public static final String PARAMETER_KEEP_ALL_ATTRIBUTES = "keep_all_attributes";

    public Stacking(OperatorDescription description) {
        super(description, "Base Learner", "Stacking Model Learner");
        this.getTransformer().addRule(new MDTransformationRule(){

            @Override
            public void transformMD() {
                MetaData unmodifiedMetaData = Stacking.this.exampleSetInput.getMetaData().clone();
                if (unmodifiedMetaData instanceof ExampleSetMetaData) {
                    ExampleSetMetaData emd = (ExampleSetMetaData)unmodifiedMetaData;
                    if (!Stacking.this.keepOldAttributes()) {
                        emd.clearRegular();
                    }
                    List<MetaData> metaDatas = Stacking.this.baseModelExtender.getMetaData(true);
                    int numberOfModels = 0;
                    for (MetaData md : metaDatas) {
                        if (!PredictionModel.class.isAssignableFrom(md.getObjectClass())) continue;
                        ++numberOfModels;
                    }
                    AttributeMetaData label = emd.getLabelMetaData();
                    for (int i = 0; i < numberOfModels; ++i) {
                        AttributeMetaData newRegular = label.copy();
                        newRegular.setName("base_prediction" + i);
                        newRegular.setRole("attribute");
                        emd.addAttribute(newRegular);
                    }
                    Stacking.this.stackingExamplesInnerSource.deliverMD(emd);
                }
                Stacking.this.stackingExamplesInnerSource.deliverMD(unmodifiedMetaData);
            }
        });
        this.getTransformer().addRule(new SubprocessTransformRule(this.getSubprocess(1)));
    }

    @Override
    public String getModelName() {
        return "Stacking Model";
    }

    @Override
    public boolean keepOldAttributes() {
        return this.getParameterAsBoolean(PARAMETER_KEEP_ALL_ATTRIBUTES);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean(PARAMETER_KEEP_ALL_ATTRIBUTES, "Indicates if all attributes (including the original ones) in order to learn the stacked model.", true));
        return types;
    }

    @Override
    protected ExecutionUnit getBaseModelLearnerProcess() {
        return this.getSubprocess(0);
    }

    @Override
    protected Model getStackingModel(ExampleSet stackingLearningSet) throws OperatorException {
        this.stackingExamplesInnerSource.deliver(stackingLearningSet);
        this.getSubprocess(1).execute();
        return (Model)this.stackingModelInnerSink.getData();
    }
}

