/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.meta;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCapability;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.learner.meta.AbstractMetaLearner;
import com.rapidminer.operator.learner.meta.RelativeRegressionModel;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.tools.Ontology;
import java.util.List;

public class RelativeRegression
extends AbstractMetaLearner {
    public static final String PARAMETER_RELATIVE_ATTRIBUTE = "relative_attribute";

    public RelativeRegression(OperatorDescription description) {
        super(description);
    }

    @Override
    public Model learn(ExampleSet exampleSet) throws OperatorException {
        Attribute relativeAttribute = exampleSet.getAttributes().get(this.getParameter(PARAMETER_RELATIVE_ATTRIBUTE));
        if (relativeAttribute == null) {
            throw new UserError((Operator)this, 111, this.getParameter(PARAMETER_RELATIVE_ATTRIBUTE));
        }
        if (!relativeAttribute.isNumerical()) {
            throw new UserError((Operator)this, 120, relativeAttribute.getName(), Ontology.VALUE_TYPE_NAMES[relativeAttribute.getValueType()], Ontology.VALUE_TYPE_NAMES[2]);
        }
        String relativeAttributeName = relativeAttribute.getName();
        Attribute originalLabel = exampleSet.getAttributes().getLabel();
        Attribute transformedLabel = AttributeFactory.createAttribute(originalLabel, "Relative");
        exampleSet.getExampleTable().addAttribute(transformedLabel);
        exampleSet.getAttributes().addRegular(transformedLabel);
        for (Example e : exampleSet) {
            double originalLabelValue = e.getValue(originalLabel);
            double relativeValue = e.getValue(relativeAttribute);
            e.setValue(transformedLabel, originalLabelValue - relativeValue);
        }
        exampleSet.getAttributes().remove(originalLabel);
        exampleSet.getAttributes().setLabel(transformedLabel);
        Model baseModel = this.applyInnerLearner(exampleSet);
        exampleSet.getAttributes().remove(transformedLabel);
        exampleSet.getExampleTable().removeAttribute(transformedLabel);
        exampleSet.getAttributes().setLabel(originalLabel);
        return new RelativeRegressionModel(exampleSet, baseModel, relativeAttributeName);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeAttribute type = new ParameterTypeAttribute(PARAMETER_RELATIVE_ATTRIBUTE, "Select the attribute which should be used as a base for the relative comparison.", this.exampleSetInput, new int[]{2}){
            private static final long serialVersionUID = 384379555037475293L;

            @Override
            protected boolean isFilteredOut(AttributeMetaData amd) {
                String role = amd.getRole();
                if (role != null) {
                    return amd.getRole().equals("label");
                }
                return false;
            }
        };
        type.setExpert(false);
        types.add(type);
        return types;
    }

    @Override
    public boolean supportsCapability(OperatorCapability capability) {
        switch (capability) {
            case POLYNOMINAL_LABEL: 
            case BINOMINAL_LABEL: 
            case NO_LABEL: 
            case UPDATABLE: 
            case FORMULA_PROVIDER: {
                return false;
            }
        }
        return true;
    }
}

