/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.meta;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.operator.learner.meta.MetaModel;
import com.rapidminer.tools.Tools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class MultiModelByRegression
extends PredictionModel
implements MetaModel {
    private static final long serialVersionUID = 4526668088304067678L;
    private Model[] models;

    public MultiModelByRegression(ExampleSet exampleSet, Model[] models) {
        super(exampleSet);
        this.models = models;
    }

    public int getNumberOfModels() {
        return this.models.length;
    }

    public Model getModel(int index) {
        return this.models[index];
    }

    @Override
    public ExampleSet performPrediction(ExampleSet exampleSet, Attribute predictedLabelAttribute) throws OperatorException {
        ExampleSet[] eSet = new ExampleSet[this.getNumberOfModels()];
        for (int i = 0; i < this.getNumberOfModels(); ++i) {
            Model model = this.getModel(i);
            eSet[i] = (ExampleSet)exampleSet.clone();
            eSet[i] = model.apply(eSet[i]);
        }
        ArrayList reader = new ArrayList(eSet.length);
        for (int r = 0; r < eSet.length; ++r) {
            reader.add(eSet[r].iterator());
        }
        Iterator originalReader = exampleSet.iterator();
        Attribute predictedLabel = exampleSet.getAttributes().getPredictedLabel();
        while (originalReader.hasNext()) {
            double bestLabel = Double.NaN;
            double highestFunctionValue = Double.NEGATIVE_INFINITY;
            for (int k = 0; k < reader.size(); ++k) {
                double functionValue = ((Example)((Iterator)reader.get(k)).next()).getPredictedLabel();
                if (!(functionValue > highestFunctionValue)) continue;
                highestFunctionValue = functionValue;
                bestLabel = k;
            }
            Example example = (Example)originalReader.next();
            example.setPredictedLabel(bestLabel);
            example.setConfidence(predictedLabel.getMapping().mapIndex((int)bestLabel), 1.0);
        }
        return exampleSet;
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer(super.toString() + Tools.getLineSeparator());
        for (int i = 0; i < this.models.length; ++i) {
            result.append((i > 0 ? Tools.getLineSeparator() : "") + this.models[i].toString());
        }
        return result.toString();
    }

    @Override
    public List<String> getModelNames() {
        LinkedList<String> names = new LinkedList<String>();
        for (int i = 0; i < this.getNumberOfModels(); ++i) {
            names.add("Model " + (i + 1));
        }
        return names;
    }

    public List<Model> getModels() {
        return Arrays.asList(this.models);
    }
}

