/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.meta;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.operator.learner.meta.MetaModel;
import com.rapidminer.tools.Tools;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class MetaCostModel
extends PredictionModel
implements MetaModel {
    private static final long serialVersionUID = -7378871544357578954L;
    private Model[] models;
    private double[][] costMatrix;

    public MetaCostModel(ExampleSet exampleSet, Model[] models, double[][] costMatrix) {
        super(exampleSet);
        this.models = models;
        this.costMatrix = costMatrix;
    }

    public int getNumberOfModels() {
        return this.models.length;
    }

    public Model getModel(int index) {
        return this.models[index];
    }

    public double getCostValue(int i, int j) {
        return this.costMatrix[i][j];
    }

    @Override
    public ExampleSet performPrediction(ExampleSet originalExampleSet, Attribute predictedLabel) throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)originalExampleSet.clone();
        int numberOfClasses = this.getLabel().getMapping().getValues().size();
        double[][] confidences = new double[exampleSet.size()][numberOfClasses];
        int currentNumber = 0;
        HashMap<Integer, String> classIndexMap = new HashMap<Integer, String>(numberOfClasses);
        for (String currentClass : this.getLabel().getMapping().getValues()) {
            classIndexMap.put(currentNumber, currentClass);
            ++currentNumber;
        }
        for (int k = 0; k < this.getNumberOfModels(); ++k) {
            Model model = this.getModel(k);
            exampleSet = model.apply(exampleSet);
            Iterator reader = exampleSet.iterator();
            int counter = 0;
            while (reader.hasNext()) {
                Example example = (Example)reader.next();
                int currentClassNumber = 0;
                for (String currentClass : this.getLabel().getMapping().getValues()) {
                    double confidence = example.getConfidence(currentClass);
                    double[] dArray = confidences[counter];
                    int n = currentClassNumber++;
                    dArray[n] = dArray[n] + confidence;
                }
                ++counter;
            }
            PredictionModel.removePredictedLabel(exampleSet);
        }
        Attribute classificationCost = AttributeFactory.createAttribute("cost", 4);
        originalExampleSet.getExampleTable().addAttribute(classificationCost);
        originalExampleSet.getAttributes().setCost(classificationCost);
        int counter = 0;
        for (Example example : originalExampleSet) {
            int i;
            for (int i2 = 0; i2 < numberOfClasses; ++i2) {
                confidences[counter][i2] = confidences[counter][i2] / (double)this.getNumberOfModels();
            }
            double[] expectedCosts = new double[numberOfClasses];
            int bestIndex = 0;
            double bestValue = Double.POSITIVE_INFINITY;
            for (i = 0; i < numberOfClasses; ++i) {
                for (int j = 0; j < numberOfClasses; ++j) {
                    int n = i;
                    expectedCosts[n] = expectedCosts[n] + confidences[counter][j] * this.costMatrix[i][j];
                }
                if (!(expectedCosts[i] < bestValue)) continue;
                bestValue = expectedCosts[i];
                bestIndex = i;
            }
            example.setValue(predictedLabel, this.getLabel().getMapping().mapString((String)classIndexMap.get(bestIndex)));
            example.setValue(classificationCost, expectedCosts[bestIndex]);
            for (i = 0; i < numberOfClasses; ++i) {
                example.setConfidence((String)classIndexMap.get(i), confidences[counter][i]);
            }
            ++counter;
        }
        return originalExampleSet;
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer(super.toString() + Tools.getLineSeparator());
        for (int i = 0; i < this.models.length; ++i) {
            result.append((i > 0 ? Tools.getLineSeparator() : "") + this.models[i].toString());
        }
        return result.toString();
    }

    @Override
    public List<String> getModelNames() {
        LinkedList<String> names = new LinkedList<String>();
        for (int i = 0; i < this.getNumberOfModels(); ++i) {
            names.add("Model " + (i + 1));
        }
        return names;
    }

    public List<Model> getModels() {
        return Arrays.asList(this.models);
    }
}

