/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.meta;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.MappedExampleSet;
import com.rapidminer.example.set.SplittedExampleSet;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorCapability;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.meta.AbstractMetaLearner;
import com.rapidminer.operator.learner.meta.MetaCostModel;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeMatrix;
import com.rapidminer.tools.RandomGenerator;
import java.util.List;

public class MetaCost
extends AbstractMetaLearner {
    public static final String PARAMETER_COST_MATRIX = "cost_matrix";
    public static final String PARAMETER_COST_MATRIX_FILE_LOCATION = "cost_matrix_file_location";
    public static final String PARAMETER_USE_SUBSET_FOR_TRAINING = "use_subset_for_training";
    public static final String PARAMETER_ITERATIONS = "iterations";
    public static final String PARAMETER_SAMPLING_WITH_REPLACEMENT = "sampling_with_replacement";

    public MetaCost(OperatorDescription description) {
        super(description);
    }

    @Override
    public Model learn(ExampleSet inputSet) throws OperatorException {
        int iterations = this.getParameterAsInt(PARAMETER_ITERATIONS);
        double subsetRatio = this.getParameterAsDouble(PARAMETER_USE_SUBSET_FOR_TRAINING);
        Model[] models = new Model[iterations];
        double[][] costMatrix = this.getParameterAsMatrix(PARAMETER_COST_MATRIX);
        if (this.getParameterAsBoolean(PARAMETER_SAMPLING_WITH_REPLACEMENT)) {
            RandomGenerator randomGenerator = RandomGenerator.getRandomGenerator(this);
            int size = (int)((double)inputSet.size() * subsetRatio);
            for (int i = 0; i < iterations; ++i) {
                ExampleSet exampleSet = (ExampleSet)inputSet.clone();
                int[] mapping = MappedExampleSet.createBootstrappingMapping(exampleSet, size, randomGenerator);
                MappedExampleSet currentSampleSet = new MappedExampleSet(exampleSet, mapping);
                models[i] = this.applyInnerLearner(currentSampleSet);
                this.inApplyLoop();
            }
        } else {
            for (int i = 0; i < iterations; ++i) {
                SplittedExampleSet splitted = new SplittedExampleSet((ExampleSet)inputSet.clone(), subsetRatio, 1, this.getParameterAsBoolean("use_local_random_seed"), this.getParameterAsInt("local_random_seed"));
                splitted.selectSingleSubset(0);
                models[i] = this.applyInnerLearner(splitted);
                this.inApplyLoop();
            }
        }
        return new MetaCostModel(inputSet, models, costMatrix);
    }

    @Override
    public boolean supportsCapability(OperatorCapability capability) {
        switch (capability) {
            case NUMERICAL_LABEL: 
            case NO_LABEL: 
            case UPDATABLE: 
            case FORMULA_PROVIDER: {
                return false;
            }
        }
        return true;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeMatrix(PARAMETER_COST_MATRIX, "The cost matrix in Matlab single line format", "Cost Matrix", "Predicted Class", "True Class", true, false));
        types.add(new ParameterTypeDouble(PARAMETER_USE_SUBSET_FOR_TRAINING, "Fraction of examples used for training. Must be greater than 0 and should be lower than 1.", 0.0, 1.0, 1.0));
        types.add(new ParameterTypeInt(PARAMETER_ITERATIONS, "The number of iterations (base models).", 1, Integer.MAX_VALUE, 10));
        types.add(new ParameterTypeBoolean(PARAMETER_SAMPLING_WITH_REPLACEMENT, "Use sampling with replacement (true) or without (false)", true));
        types.addAll(RandomGenerator.getRandomGeneratorParameters(this));
        return types;
    }
}

