/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.meta;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.operator.learner.meta.MetaModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

@Deprecated
public class HierarchicalModel
extends PredictionModel
implements MetaModel {
    private static final long serialVersionUID = -5792943818860734082L;
    private final Node root;

    public HierarchicalModel(ExampleSet exampleSet, Node root) {
        super(exampleSet);
        this.root = root;
    }

    @Override
    public ExampleSet performPrediction(ExampleSet exampleSet, Attribute predictedLabel) throws OperatorException {
        ExampleSet eSet = (ExampleSet)exampleSet.clone();
        int numberOfClasses = this.getLabel().getMapping().getValues().size();
        HashMap<String, Integer> classIndexMap = new HashMap<String, Integer>(numberOfClasses);
        for (String currentClass : this.getLabel().getMapping().getValues()) {
            classIndexMap.put(currentClass, this.getLabel().getMapping().mapString(currentClass));
        }
        double[][] confidenceMatrix = new double[eSet.size()][numberOfClasses];
        for (int i = 0; i < confidenceMatrix.length; ++i) {
            for (int j = 0; j < confidenceMatrix[i].length; ++j) {
                confidenceMatrix[i][j] = 1.0;
            }
        }
        this.performPrediction(eSet, predictedLabel, this.root, confidenceMatrix, classIndexMap);
        int counter = 0;
        for (Example example : exampleSet) {
            double predictedValue = 0.0;
            double maxConfidence = 0.0;
            for (Map.Entry<String, Integer> entry : classIndexMap.entrySet()) {
                example.setConfidence(entry.getKey(), confidenceMatrix[counter][entry.getValue()]);
                if (!(confidenceMatrix[counter][entry.getValue()] > maxConfidence)) continue;
                maxConfidence = confidenceMatrix[counter][entry.getValue()];
                predictedValue = entry.getValue().intValue();
            }
            example.setPredictedLabel(predictedValue);
            ++counter;
        }
        return exampleSet;
    }

    public void performPrediction(ExampleSet eSet, Attribute predictedLabel, Node node, double[][] confidenceMatrix, HashMap<String, Integer> classIndexMap) throws OperatorException {
        if (node.getModel() != null && node.getChildren().size() > 0) {
            System.err.println("Predicting " + node.getClassName());
            eSet = node.getModel().apply(eSet);
            int counter = 0;
            for (Example example : eSet) {
                for (Node child : node.getChildren()) {
                    double confidence = example.getConfidence(child.getClassName());
                    for (String className : child.getLeaveClasses()) {
                        double[] dArray = confidenceMatrix[counter];
                        int n = classIndexMap.get(className);
                        dArray[n] = dArray[n] * confidence;
                    }
                }
                ++counter;
            }
            PredictionModel.removePredictedLabel(eSet);
        }
        for (Node child : node.getChildren()) {
            this.performPrediction(eSet, predictedLabel, child, confidenceMatrix, classIndexMap);
        }
    }

    @Override
    public List<String> getModelNames() {
        LinkedList<String> names = new LinkedList<String>();
        return names;
    }

    public List<Model> getModels() {
        return Arrays.asList(new Object[0]);
    }

    public static class Node
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String className;
        private final List<Node> children = new ArrayList<Node>();
        private Node parent = null;
        private Model model = null;

        public Node(String className) {
            this.className = className;
        }

        public List<Node> getChildren() {
            return this.children;
        }

        public void addChild(Node child) {
            this.children.add(child);
            child.setParent(this);
        }

        public void setParent(Node parent) {
            this.parent = parent;
        }

        public Node getParent() {
            return this.parent;
        }

        public String getClassName() {
            return this.className;
        }

        public List<String> getChildrenClasses() {
            ArrayList<String> childrenClasses = new ArrayList<String>();
            for (Node child : this.children) {
                childrenClasses.add(child.getClassName());
                childrenClasses.addAll(child.getChildrenClasses());
            }
            return childrenClasses;
        }

        public List<String> getLeaveClasses() {
            ArrayList<String> leaveClasses = new ArrayList<String>();
            for (Node child : this.children) {
                leaveClasses.addAll(child.getLeaveClasses());
            }
            if (this.children.size() == 0) {
                leaveClasses.add(this.className);
            }
            return leaveClasses;
        }

        public void setModel(Model model) {
            this.model = model;
        }

        public Model getModel() {
            return this.model;
        }
    }
}

