/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.meta;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.Condition;
import com.rapidminer.example.set.ConditionCreationException;
import com.rapidminer.example.set.ConditionedExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorCapability;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.meta.AbstractMetaLearner;
import com.rapidminer.operator.learner.meta.HierarchicalModel;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.tools.RandomGenerator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

@Deprecated
public class HierarchicalLearner
extends AbstractMetaLearner {
    public static final String PARAMETER_HIERARCHY = "hierarchy";
    public static final String PARAMETER_PARENT_CLASS = "parent_class";
    public static final String PARAMETER_CHILD_CLASS = "child_class";

    public HierarchicalLearner(OperatorDescription description) {
        super(description);
    }

    @Override
    public Model learn(ExampleSet inputSet) throws OperatorException {
        Attribute classLabel = inputSet.getAttributes().getLabel();
        if (classLabel.getMapping().size() == 2) {
            return this.applyInnerLearner(inputSet);
        }
        List<String[]> hierarchyEntries = this.getParameterList(PARAMETER_HIERARCHY);
        HashMap<String, HierarchicalModel.Node> nodeMap = new HashMap<String, HierarchicalModel.Node>();
        HashSet<HierarchicalModel.Node> innerNodes = new HashSet<HierarchicalModel.Node>();
        for (String[] entries : hierarchyEntries) {
            HierarchicalModel.Node childNode;
            String parentClass = entries[0];
            String childClass = entries[1];
            HierarchicalModel.Node parentNode = (HierarchicalModel.Node)nodeMap.get(parentClass);
            if (parentNode == null) {
                parentNode = new HierarchicalModel.Node(parentClass);
            }
            if ((childNode = (HierarchicalModel.Node)nodeMap.get(childClass)) == null) {
                childNode = new HierarchicalModel.Node(childClass);
            }
            parentNode.addChild(childNode);
            nodeMap.put(parentClass, parentNode);
            nodeMap.put(childClass, childNode);
            innerNodes.add(childNode);
        }
        HierarchicalModel.Node root = new HierarchicalModel.Node("_ROOT_");
        for (HierarchicalModel.Node node : nodeMap.values()) {
            if (innerNodes.contains(node)) continue;
            root.addChild(node);
        }
        try {
            this.computeModel(root, inputSet, classLabel);
        }
        catch (ConditionCreationException e) {
            e.printStackTrace();
        }
        return new HierarchicalModel(inputSet, root);
    }

    private void computeModel(HierarchicalModel.Node node, ExampleSet eSet, Attribute originalLabel) throws ConditionCreationException, OperatorException {
        HashMap<String, String> classesMap = new HashMap<String, String>();
        for (HierarchicalModel.Node child : node.getChildren()) {
            if (child.getChildrenClasses().size() > 0) {
                for (String childClass : child.getChildrenClasses()) {
                    classesMap.put(childClass, child.getClassName());
                }
                continue;
            }
            classesMap.put(child.getClassName(), child.getClassName());
        }
        eSet.getAttributes().setSpecialAttribute(originalLabel, "label_original");
        Attribute workingLabel = AttributeFactory.createAttribute(originalLabel.getName() + "_" + node.getClassName(), originalLabel.getValueType());
        eSet.getExampleTable().addAttribute(workingLabel);
        eSet.getAttributes().addRegular(workingLabel);
        for (Example example : eSet) {
            double index = example.getValue(originalLabel);
            if (!Double.isNaN(index)) {
                String value = originalLabel.getMapping().mapIndex((int)index);
                String mapVl = (String)classesMap.get(value);
                if (mapVl != null) {
                    example.setValue(workingLabel, workingLabel.getMapping().mapString(mapVl));
                    continue;
                }
                example.setValue(workingLabel, Double.NaN);
                continue;
            }
            example.setValue(workingLabel, Double.NaN);
        }
        eSet.getAttributes().setLabel(workingLabel);
        Model model = this.applyInnerLearner(eSet);
        node.setModel(model);
        for (HierarchicalModel.Node child : node.getChildren()) {
            if (child.getChildren().size() <= 0) continue;
            Condition c = ConditionedExampleSet.createCondition(ConditionedExampleSet.KNOWN_CONDITION_NAMES[7], eSet, workingLabel.getName() + "=" + child.getClassName());
            ConditionedExampleSet trainingSet = new ConditionedExampleSet(eSet, c);
            this.computeModel(child, trainingSet, originalLabel);
        }
        eSet.getAttributes().setLabel(originalLabel);
        eSet.getAttributes().remove(workingLabel);
        eSet.getExampleTable().removeAttribute(workingLabel);
    }

    @Override
    public boolean supportsCapability(OperatorCapability capability) {
        switch (capability) {
            case NUMERICAL_LABEL: 
            case NO_LABEL: 
            case UPDATABLE: 
            case FORMULA_PROVIDER: {
                return false;
            }
        }
        return true;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeList(PARAMETER_HIERARCHY, "The hierarchy...", (ParameterType)new ParameterTypeString(PARAMETER_PARENT_CLASS, "The parent class.", false), (ParameterType)new ParameterTypeString(PARAMETER_CHILD_CLASS, "The child class.", false)));
        types.addAll(RandomGenerator.getRandomGeneratorParameters(this));
        return types;
    }
}

