/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.meta;

import java.io.Serializable;

public class ContingencyMatrix
implements Serializable {
    private static final long serialVersionUID = -4919765585974259997L;
    private final double[][] matrix;
    private final double[] rowSums;
    private final double[] colSums;
    private final double total;

    public ContingencyMatrix(double[][] contigencyMatrix) {
        this.matrix = new double[contigencyMatrix.length][];
        for (int i = 0; i < this.matrix.length; ++i) {
            this.matrix[i] = new double[contigencyMatrix[i].length];
            System.arraycopy(contigencyMatrix[i], 0, this.matrix[i], 0, this.matrix[i].length);
        }
        double totalSum = 0.0;
        this.rowSums = new double[this.matrix.length];
        for (int row = 0; row < this.rowSums.length; ++row) {
            double prior = 0.0;
            double[] entries = this.matrix[row];
            for (int i = 0; i < entries.length; ++i) {
                prior += entries[i];
            }
            this.rowSums[row] = prior;
            totalSum += prior;
        }
        this.total = totalSum;
        this.colSums = new double[this.matrix.length > 0 ? this.matrix[0].length : 0];
        for (int col = 0; col < this.colSums.length; ++col) {
            double sum = 0.0;
            for (int i = 0; i < this.matrix.length; ++i) {
                sum += this.matrix[i][col];
            }
            this.colSums[col] = sum;
        }
    }

    public double[][] getMatrix() {
        double[][] result = new double[this.matrix.length][];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new double[this.matrix[i].length];
            System.arraycopy(this.matrix[i], 0, result[i], 0, this.matrix[i].length);
        }
        return result;
    }

    public int getNumberOfClasses() {
        return this.rowSums.length;
    }

    public int getNumberOfPredictions() {
        return this.colSums.length;
    }

    public double[] getPriors() {
        double[] priors = new double[this.rowSums.length];
        for (int i = 0; i < priors.length; ++i) {
            priors[i] = this.getPrior(i);
        }
        return priors;
    }

    public double getPrior(int trueLabel) {
        return this.rowSums[trueLabel] / this.total;
    }

    public double getCoverage(int predictedLabel) {
        return this.colSums[predictedLabel] / this.total;
    }

    public double getProbability(int trueLabel, int predictedLabel) {
        return this.matrix[trueLabel][predictedLabel] / this.total;
    }

    public double getPrecision(int trueLabel, int predictedLabel) {
        return this.getProbability(trueLabel, predictedLabel) / this.getCoverage(predictedLabel);
    }

    public double getLift(int trueLabel, int predictedLabel) {
        if (this.getCoverage(predictedLabel) <= 0.0) {
            return Double.NaN;
        }
        return this.getPrecision(trueLabel, predictedLabel) / this.getPrior(trueLabel);
    }

    public double getLiftRatio(int trueLabel, int predictedLabel) {
        double liftPos = this.getLift(trueLabel, predictedLabel);
        if (Double.isNaN(liftPos) || Double.isInfinite(liftPos)) {
            return liftPos;
        }
        double precNeg = 1.0 - this.getPrecision(trueLabel, predictedLabel);
        double priorNeg = 1.0 - this.getPrior(trueLabel);
        if (priorNeg <= 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        double liftNeg = precNeg / priorNeg;
        return liftPos / liftNeg;
    }

    public double[] getLiftRatiosForPrediction(int predictedLabel) {
        double[] liftRatios = new double[this.matrix.length];
        for (int i = 0; i < liftRatios.length; ++i) {
            liftRatios[i] = this.getLiftRatio(i, predictedLabel);
        }
        return liftRatios;
    }

    public double getAccuracy() {
        double sum = 0.0;
        for (int row = 0; row < this.matrix.length; ++row) {
            if (this.matrix[row].length <= row) continue;
            sum += this.matrix[row][row];
        }
        return sum / this.total;
    }

    public double getErrorRate() {
        return 1.0 - this.getAccuracy();
    }

    public double getTotalWeight() {
        return this.total;
    }

    public ContingencyMatrix clone() {
        return new ContingencyMatrix(this.matrix);
    }
}

