/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.meta;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorCapability;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.operator.learner.meta.AbstractMetaLearner;
import com.rapidminer.operator.learner.meta.MultiModelByRegression;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MDReal;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.PredictionModelMetaData;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.ports.metadata.SimpleMetaDataError;
import com.rapidminer.tools.math.container.Range;

public class ClassificationByRegression
extends AbstractMetaLearner {
    private int numberOfClasses;

    public ClassificationByRegression(OperatorDescription description) {
        super(description);
    }

    @Override
    protected MetaData modifyExampleSetMetaData(ExampleSetMetaData unmodifiedMetaData) {
        switch (unmodifiedMetaData.hasSpecial("label")) {
            case NO: {
                this.getTrainingSetInputPort().addError(new SimpleMetaDataError(ProcessSetupError.Severity.ERROR, (Port)this.getTrainingSetInputPort(), "special_missing", "label"));
                return unmodifiedMetaData;
            }
            case UNKNOWN: {
                this.getTrainingSetInputPort().addError(new SimpleMetaDataError(ProcessSetupError.Severity.WARNING, (Port)this.getTrainingSetInputPort(), "special_unknown", "label"));
                return unmodifiedMetaData;
            }
            case YES: {
                AttributeMetaData labelMD = unmodifiedMetaData.getLabelMetaData();
                unmodifiedMetaData.removeAttribute(labelMD);
                AttributeMetaData transformedMD = new AttributeMetaData("regression(" + labelMD.getName() + ")", 4, "label");
                transformedMD.setValueRange(new Range(-1.0, 1.0), SetRelation.EQUAL);
                transformedMD.setValueSetRelation(SetRelation.EQUAL);
                transformedMD.setMean(new MDReal());
                unmodifiedMetaData.addAttribute(transformedMD);
                return unmodifiedMetaData;
            }
        }
        return unmodifiedMetaData;
    }

    @Override
    protected MetaData modifyGeneratedModelMetaData(PredictionModelMetaData unmodifiedMetaData) {
        InputPort in = this.getTrainingSetInputPort();
        MetaData esetIn = in.getMetaData();
        if (esetIn != null && esetIn instanceof ExampleSetMetaData) {
            return new PredictionModelMetaData((Class<? extends PredictionModel>)MultiModelByRegression.class, (ExampleSetMetaData)esetIn);
        }
        return unmodifiedMetaData;
    }

    @Override
    public Model learn(ExampleSet inputSet) throws OperatorException {
        Attribute classLabel = inputSet.getAttributes().getLabel();
        this.numberOfClasses = classLabel.getMapping().getValues().size();
        Model[] models = new Model[this.numberOfClasses];
        ExampleSet eSet = (ExampleSet)inputSet.clone();
        Attribute tempLabel = AttributeFactory.createAttribute("regression(" + classLabel.getName() + ")", 4);
        eSet.getExampleTable().addAttribute(tempLabel);
        eSet.getAttributes().setLabel(tempLabel);
        for (int i = 0; i < this.numberOfClasses; ++i) {
            for (Example e : eSet) {
                if (e.getValue(classLabel) == (double)i) {
                    e.setValue(tempLabel, 1.0);
                    continue;
                }
                e.setValue(tempLabel, -1.0);
            }
            models[i] = this.applyInnerLearner(eSet);
            this.inApplyLoop();
        }
        return new MultiModelByRegression(inputSet, models);
    }

    @Override
    public boolean supportsCapability(OperatorCapability lc) {
        switch (lc) {
            case NUMERICAL_LABEL: 
            case NO_LABEL: 
            case UPDATABLE: 
            case FORMULA_PROVIDER: {
                return false;
            }
        }
        return true;
    }
}

