/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.meta;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.operator.learner.meta.MetaModel;
import com.rapidminer.tools.Tools;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Binary2MultiClassModel
extends PredictionModel
implements MetaModel {
    private static final long serialVersionUID = -8146985010710684043L;
    private static final int ONE_AGAINST_ALL = 0;
    private static final int ONE_AGAINST_ONE = 1;
    private static final int EXHAUSTIVE_CODE = 2;
    private static final int RANDOM_CODE = 3;
    private final Model[] models;
    private LinkedList<String> modelNames;
    private String[][] codeMatrix;
    private final int classificationType;

    public Binary2MultiClassModel(ExampleSet exampleSet, Model[] models, int classificationType, LinkedList<String> modelNames) {
        super(exampleSet);
        this.models = models;
        this.classificationType = classificationType;
        this.modelNames = modelNames;
    }

    public Binary2MultiClassModel(ExampleSet exampleSet, Model[] models, int classificationType, String[][] codeMatrix) {
        super(exampleSet);
        this.models = models;
        this.classificationType = classificationType;
        this.codeMatrix = codeMatrix;
    }

    public int getNumberOfModels() {
        return this.models.length;
    }

    public Model getModel(int index) {
        return this.models[index];
    }

    private void startNonECOCProcess(ExampleSet originalExampleSet, int classificationStrategy) throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)originalExampleSet.clone();
        int numberOfClasses = this.getLabel().getMapping().getValues().size();
        int currentNumber = 0;
        HashMap<Integer, Integer> classIndexMap = new HashMap<Integer, Integer>(numberOfClasses);
        for (String currentClass : this.getLabel().getMapping().getValues()) {
            classIndexMap.put(currentNumber, this.getLabel().getMapping().mapString(currentClass));
            ++currentNumber;
        }
        double[][] confidenceMatrix = new double[exampleSet.size()][this.getNumberOfModels()];
        for (int k = 0; k < confidenceMatrix[0].length; ++k) {
            Model model = this.getModel(k);
            exampleSet = model.apply(exampleSet);
            Iterator reader = exampleSet.iterator();
            int counter = 0;
            while (reader.hasNext()) {
                Example example = (Example)reader.next();
                if (classificationStrategy == 1) {
                    for (String className : exampleSet.getAttributes().getPredictedLabel().getMapping().getValues()) {
                        double[] dArray = confidenceMatrix[counter];
                        int n = this.getLabel().getMapping().mapString(className);
                        dArray[n] = dArray[n] + example.getConfidence(className);
                    }
                } else {
                    Integer index = (Integer)classIndexMap.get(k);
                    confidenceMatrix[counter][k] = example.getConfidence(this.getLabel().getMapping().mapIndex(index));
                }
                ++counter;
            }
            PredictionModel.removePredictedLabel(exampleSet);
        }
        Iterator reader = originalExampleSet.iterator();
        int counter = 0;
        while (reader.hasNext()) {
            int i;
            Example example = (Example)reader.next();
            double confidenceSum = 0.0;
            double currentConfidence = 0.0;
            double bestConfidence = Double.NEGATIVE_INFINITY;
            int bestIndex = -1;
            for (i = 0; i < confidenceMatrix[counter].length; ++i) {
                currentConfidence = confidenceMatrix[counter][i];
                if (currentConfidence > bestConfidence) {
                    bestConfidence = currentConfidence;
                    bestIndex = i;
                }
                confidenceSum += currentConfidence;
            }
            example.setPredictedLabel(((Integer)classIndexMap.get(bestIndex)).intValue());
            for (i = 0; i < numberOfClasses; ++i) {
                example.setConfidence(this.getLabel().getMapping().mapIndex((Integer)classIndexMap.get(i)), confidenceMatrix[counter][i] / confidenceSum);
            }
            ++counter;
        }
    }

    private void startECOCProcess(ExampleSet originalExampleSet, String[][] codeMatrix) throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)originalExampleSet.clone();
        int numberOfClasses = codeMatrix.length;
        int currentNumber = 0;
        HashMap<Integer, String> classIndexMap = new HashMap<Integer, String>(numberOfClasses);
        for (String currentClass : this.getLabel().getMapping().getValues()) {
            classIndexMap.put(currentNumber, currentClass);
            ++currentNumber;
        }
        double[][] codeWords = new double[codeMatrix.length][codeMatrix[0].length];
        for (int i = 0; i < codeMatrix.length; ++i) {
            for (int j = 0; j < codeMatrix[0].length; ++j) {
                codeWords[i][j] = "true".equals(codeMatrix[i][j]) ? 1.0 : 0.0;
            }
        }
        double[][] confidenceMatrix = new double[exampleSet.size()][this.getNumberOfModels()];
        for (int k = 0; k < confidenceMatrix[0].length; ++k) {
            Model model = this.getModel(k);
            exampleSet = model.apply(exampleSet);
            Iterator reader = exampleSet.iterator();
            int counter = 0;
            while (reader.hasNext()) {
                Example example = (Example)reader.next();
                Attribute predictedLabel = example.getAttributes().getPredictedLabel();
                String currentLabel = predictedLabel.getMapping().mapIndex((int)example.getValue(predictedLabel));
                double currentConfidence = example.getConfidence(currentLabel);
                confidenceMatrix[counter][k] = "true".equals(currentLabel) ? currentConfidence : 1.0 - currentConfidence;
                ++counter;
            }
            PredictionModel.removePredictedLabel(exampleSet);
        }
        Iterator reader = originalExampleSet.iterator();
        int counter = 0;
        while (reader.hasNext()) {
            Example example = (Example)reader.next();
            int bestIndex = -1;
            double[] confidenceVector = new double[numberOfClasses];
            double bestConfidence = Double.POSITIVE_INFINITY;
            for (int i = 0; i < numberOfClasses; ++i) {
                confidenceVector[i] = 0.0;
                for (int j = 0; j < confidenceMatrix[counter].length; ++j) {
                    confidenceVector[i] = confidenceVector[i] + Math.abs(confidenceMatrix[counter][j] - codeWords[i][j]);
                }
                if (!(confidenceVector[i] < bestConfidence)) continue;
                bestConfidence = confidenceVector[i];
                bestIndex = i;
            }
            example.setPredictedLabel(this.getLabel().getMapping().mapString((String)classIndexMap.get(bestIndex)));
            int numberOfFunctions = codeMatrix[0].length;
            for (int i = 0; i < numberOfClasses; ++i) {
                example.setConfidence((String)classIndexMap.get(i), ((double)numberOfFunctions - confidenceVector[i]) / (double)numberOfFunctions);
            }
            ++counter;
        }
    }

    @Override
    public ExampleSet performPrediction(ExampleSet originalExampleSet, Attribute predictedLabel) throws OperatorException {
        switch (this.classificationType) {
            case 0: {
                this.startNonECOCProcess(originalExampleSet, 0);
                break;
            }
            case 1: {
                this.startNonECOCProcess(originalExampleSet, 1);
                break;
            }
            case 2: {
                this.startECOCProcess(originalExampleSet, this.codeMatrix);
                break;
            }
            case 3: {
                this.startECOCProcess(originalExampleSet, this.codeMatrix);
                break;
            }
            default: {
                throw new OperatorException("Unknown classification strategy selected");
            }
        }
        return originalExampleSet;
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer(super.toString() + Tools.getLineSeparators(2));
        for (int i = 0; i < this.models.length; ++i) {
            result.append((i > 0 ? Tools.getLineSeparator() : "") + this.models[i].toString());
        }
        return result.toString();
    }

    @Override
    public List<String> getModelNames() {
        LinkedList<String> names = new LinkedList<String>();
        if (this.classificationType >= 2) {
            for (int index = 1; index <= this.models.length; ++index) {
                names.add("Model " + index);
            }
        } else {
            for (int index = 0; index < this.modelNames.size(); ++index) {
                names.add(this.modelNames.get(index));
            }
        }
        return names;
    }

    public List<Model> getModels() {
        return Arrays.asList(this.models);
    }
}

