/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.meta;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.operator.learner.meta.MetaModel;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class BaggingModel
extends PredictionModel
implements MetaModel {
    private static final long serialVersionUID = -4691755811263523354L;
    private List<Model> models;

    public BaggingModel(ExampleSet exampleSet, List<Model> models) {
        super(exampleSet);
        this.models = models;
    }

    public int getNumberOfModels() {
        return this.models.size();
    }

    public Model getModel(int index) {
        return this.models.get(index);
    }

    @Override
    public ExampleSet performPrediction(ExampleSet origExampleSet, Attribute predictedLabel) throws OperatorException {
        if (predictedLabel.isNominal()) {
            String attributePrefix = "BaggingModelPrediction";
            int numLabels = predictedLabel.getMapping().size();
            Attribute[] specialAttributes = new Attribute[numLabels];
            for (int i = 0; i < numLabels; ++i) {
                specialAttributes[i] = Tools.createSpecialAttribute(origExampleSet, "BaggingModelPrediction" + i, 2);
            }
            for (Example example : origExampleSet) {
                for (int i = 0; i < specialAttributes.length; ++i) {
                    example.setValue(specialAttributes[i], 0.0);
                }
            }
            Iterator reader = origExampleSet.iterator();
            for (int modelNr = 0; modelNr < this.getNumberOfModels(); ++modelNr) {
                Model model = this.getModel(modelNr);
                ExampleSet exampleSet = (ExampleSet)origExampleSet.clone();
                exampleSet = model.apply(exampleSet);
                this.updateEstimates(exampleSet, modelNr, specialAttributes);
                PredictionModel.removePredictedLabel(exampleSet);
            }
            this.evaluateSpecialAttributes(origExampleSet, specialAttributes);
            for (int i = 0; i < numLabels; ++i) {
                origExampleSet.getAttributes().remove(specialAttributes[i]);
                origExampleSet.getExampleTable().removeAttribute(specialAttributes[i]);
            }
            return origExampleSet;
        }
        double[] predictionSums = new double[origExampleSet.size()];
        for (Model model : this.models) {
            ExampleSet resultSet = model.apply((ExampleSet)origExampleSet.clone());
            int index = 0;
            Attribute innerPredictedLabel = resultSet.getAttributes().getPredictedLabel();
            for (Example example : resultSet) {
                int n = index++;
                predictionSums[n] = predictionSums[n] + example.getValue(innerPredictedLabel);
            }
            PredictionModel.removePredictedLabel(resultSet);
        }
        int index = 0;
        for (Example example : origExampleSet) {
            example.setValue(predictedLabel, predictionSums[index++] / (double)this.models.size());
        }
        return origExampleSet;
    }

    private void updateEstimates(ExampleSet exampleSet, int modelNr, Attribute[] specialAttributes) {
        int numModels = this.getNumberOfModels();
        int numClasses = this.getLabel().getMapping().size();
        for (Example example : exampleSet) {
            for (int i = 0; i < numClasses; ++i) {
                String consideredPrediction = this.getLabel().getMapping().mapIndex(i);
                double confidence = example.getConfidence(consideredPrediction);
                double value = example.getValue(specialAttributes[i]);
                example.setValue(specialAttributes[i], value += confidence / (double)numModels);
                value = example.getValue(specialAttributes[i]);
            }
        }
    }

    private void evaluateSpecialAttributes(ExampleSet exampleSet, Attribute[] specialAttributes) {
        Attribute predictedLabel = exampleSet.getAttributes().getPredictedLabel();
        for (Example example : exampleSet) {
            int bestLabel = 0;
            double bestConf = -1.0;
            for (int n = 0; n < specialAttributes.length; ++n) {
                double curConf = example.getValue(specialAttributes[n]);
                String curPredS = this.getLabel().getMapping().mapIndex(n);
                example.setConfidence(curPredS, curConf);
                if (!(curConf > bestConf)) continue;
                bestConf = curConf;
                bestLabel = n;
            }
            example.setValue(predictedLabel, predictedLabel.getMapping().mapString(this.getLabel().getMapping().mapIndex(bestLabel)));
        }
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer(super.toString() + com.rapidminer.tools.Tools.getLineSeparator() + "Number of inner models: " + this.getNumberOfModels() + com.rapidminer.tools.Tools.getLineSeparators(2));
        for (int i = 0; i < this.getNumberOfModels(); ++i) {
            Model model = this.getModel(i);
            result.append((i > 0 ? com.rapidminer.tools.Tools.getLineSeparator() : "") + "Embedded model #" + i + ":" + com.rapidminer.tools.Tools.getLineSeparator() + model.toResultString());
        }
        return result.toString();
    }

    @Override
    public List<String> getModelNames() {
        LinkedList<String> names = new LinkedList<String>();
        for (int i = 0; i < this.getNumberOfModels(); ++i) {
            names.add("Model " + (i + 1));
        }
        return names;
    }

    public List<Model> getModels() {
        return this.models;
    }
}

