/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.meta;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.SplittedExampleSet;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorCapability;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.learner.meta.AbstractMetaLearner;
import com.rapidminer.operator.learner.meta.AdaBoostModel;
import com.rapidminer.operator.learner.meta.BaggingModel;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeNumber;
import com.rapidminer.tools.RandomGenerator;
import java.util.List;
import java.util.Vector;

public class Bagging
extends AbstractMetaLearner {
    public static final String PARAMETER_ITERATIONS = "iterations";
    public static final String PARAMETER_SAMPLE_RATIO = "sample_ratio";
    public static final String PARAMETER_AVERAGE_CONFIDENCES = "average_confidences";
    protected int currentIteration;

    public Bagging(OperatorDescription description) {
        super(description);
        this.addValue(new ValueDouble("iteration", "The current iteration."){

            @Override
            public double getDoubleValue() {
                return Bagging.this.currentIteration;
            }
        });
    }

    @Override
    public Model learn(ExampleSet exampleSet) throws OperatorException {
        double splitRatio = this.getParameterAsDouble(PARAMETER_SAMPLE_RATIO);
        int numInterations = this.getParameterAsInt(PARAMETER_ITERATIONS);
        Vector<Model> modelList = new Vector<Model>();
        this.currentIteration = 0;
        while (this.currentIteration < numInterations) {
            SplittedExampleSet splitted = new SplittedExampleSet(exampleSet, splitRatio, 1, this.getParameterAsBoolean("use_local_random_seed"), this.getParameterAsInt("local_random_seed"));
            splitted.selectSingleSubset(0);
            modelList.add(this.applyInnerLearner(splitted));
            this.inApplyLoop();
            ++this.currentIteration;
        }
        boolean numerical = exampleSet.getAttributes().getLabel().isNumerical();
        if (this.getParameterAsBoolean(PARAMETER_AVERAGE_CONFIDENCES) || numerical) {
            return new BaggingModel(exampleSet, modelList);
        }
        Vector<Double> weights = new Vector<Double>();
        for (int i = 0; i < modelList.size(); ++i) {
            weights.add(1.0);
        }
        return new AdaBoostModel(exampleSet, modelList, weights);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeNumber type = new ParameterTypeDouble(PARAMETER_SAMPLE_RATIO, "Fraction of examples used for training. Must be greater than 0 and should be lower than 1.", 0.0, 1.0, 0.9);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_ITERATIONS, "The number of iterations (base models).", 1, Integer.MAX_VALUE, 10);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_AVERAGE_CONFIDENCES, "Specifies whether to average available prediction confidences or not.", true));
        types.addAll(RandomGenerator.getRandomGeneratorParameters(this));
        return types;
    }

    @Override
    public boolean supportsCapability(OperatorCapability capability) {
        switch (capability) {
            case NO_LABEL: 
            case UPDATABLE: 
            case FORMULA_PROVIDER: {
                return false;
            }
        }
        return true;
    }
}

