/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.meta;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.operator.learner.meta.MetaModel;
import com.rapidminer.tools.Tools;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class AdditiveRegressionModel
extends PredictionModel
implements MetaModel {
    private static final long serialVersionUID = -8036434608645810089L;
    private Model defaultModel;
    private Model[] residualModels;
    private double shrinkage;

    public AdditiveRegressionModel(ExampleSet exampleSet, Model defaultModel, Model[] residualModels, double shrinkage) {
        super(exampleSet);
        this.defaultModel = defaultModel;
        this.residualModels = residualModels;
        this.shrinkage = shrinkage;
    }

    @Override
    public ExampleSet performPrediction(ExampleSet exampleSet, Attribute predictedLabel) throws OperatorException {
        exampleSet = this.defaultModel.apply(exampleSet);
        double[] predictions = new double[exampleSet.size()];
        Iterator e = exampleSet.iterator();
        int counter = 0;
        while (e.hasNext()) {
            predictions[counter++] = ((Example)e.next()).getPredictedLabel();
        }
        PredictionModel.removePredictedLabel(exampleSet);
        for (int i = 0; i < this.residualModels.length; ++i) {
            exampleSet = this.residualModels[i].apply(exampleSet);
            e = exampleSet.iterator();
            counter = 0;
            while (e.hasNext()) {
                int n = counter++;
                predictions[n] = predictions[n] + this.shrinkage * ((Example)e.next()).getPredictedLabel();
            }
            PredictionModel.removePredictedLabel(exampleSet);
        }
        e = exampleSet.iterator();
        counter = 0;
        Attribute newPredictedLabel = AdditiveRegressionModel.createPredictedLabel(exampleSet, this.getLabel());
        while (e.hasNext()) {
            ((Example)e.next()).setValue(newPredictedLabel, predictions[counter++]);
        }
        return exampleSet;
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append("Default model:" + Tools.getLineSeparator() + this.defaultModel.toString() + Tools.getLineSeparator() + Tools.getLineSeparator());
        result.append("Number of base models: " + this.residualModels.length + Tools.getLineSeparator());
        result.append("Shrinkage: " + this.shrinkage + Tools.getLineSeparator());
        for (int i = 0; i < this.residualModels.length; ++i) {
            result.append(Tools.getLineSeparator() + Tools.ordinalNumber(i + 1) + " Model:" + Tools.getLineSeparator() + this.residualModels[i] + Tools.getLineSeparator());
        }
        return result.toString();
    }

    @Override
    public List<String> getModelNames() {
        LinkedList<String> names = new LinkedList<String>();
        for (int i = 1; i <= this.residualModels.length; ++i) {
            names.add("Model " + i);
        }
        return names;
    }

    public List<Model> getModels() {
        return Arrays.asList(this.residualModels);
    }
}

